#include "gmaps.h"


GMaps::GMaps(QObject *parent) :
    QObject(parent)
{
    gmaps = new QNetworkAccessManager();
    connect(gmaps,SIGNAL(finished(QNetworkReply*)),this,SLOT(parse_gmaps(QNetworkReply*)));
}

void GMaps::geocordToAddress(double lat, double lon){
    gmaps->get(QNetworkRequest("http://maps.google.com/maps/api/geocode/xml?latlng="+QString().setNum(lat)+","+QString().setNum(lon)+"&sensor=true"));
}

void GMaps::parse_gmaps(QNetworkReply *rply){
    QXmlStreamReader xml;
    QList<QString> addresses;
    QStringList tmp;
    QString str="";
    QString plz="";
    QString ort="";
    QString land="";
    if (rply->error() == QNetworkReply::NoError){
        xml.addData(rply->readAll());
        while(!xml.atEnd()){
            xml.readNext();
            if(xml.name()=="formatted_address") addresses.append(xml.readElementText());
        }
        xml.clear();
        if(addresses.size()>=1){
            tmp=addresses[0].split(", ", QString::SkipEmptyParts);
            if(tmp.size()==3){
               str=tmp[0];
               ort = tmp[1]; //.remove(QRegExp("\\d\\d\\d\\d\\d\\s"))
               land = tmp[2];
               if(land=="Deutschland"){
                   plz = ort.left(5);
                   ort = ort.remove(0,6);
               }
               qDebug()<<"Strae: "<<str;
               qDebug()<<"Plz: "<<plz;
               qDebug()<<"Ort: "<<ort;
               qDebug()<<"Land: "<<land;
               emit found_adresse(str,plz,ort,land);
            }
            else{
                emit found_error("Keine Strae in der Nhe gefunden.");
                for(int i=0;i<tmp.size();i++){
                   qDebug()<<tmp[i];
                }
                ort = tmp[0]; //.remove(QRegExp("\\d\\d\\d\\d\\d\\s"))
                land = tmp[1];
                if(land=="Deutschland"){
                    plz = ort.left(5);
                    ort = ort.remove(0,6);
                }
                emit found_adresse(str,plz,ort,land);
                return;

            }
        }
        else{
            emit found_error("Kein Ort gefunden.");
            for(int i=0;i<tmp.size();i++){
               qDebug()<<tmp[i];
            }
            land = tmp[0];
            emit found_adresse(str,plz,ort,land);
            return;
        }

    }
    else {
        emit found_neterror(rply->errorString());
    }
}
