#include "einstellungen.h"
#include "ui_einstellungen.h"
#include <QDebug>

Einstellungen::Einstellungen(int radius, QString kraftstoff, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Einstellungen)
{
    ui->setupUi(this);
    default_radius=radius;
    default_kraftstoff=kraftstoff;

    if(kraftstoff=="Diesel") ui->comboBox->setCurrentIndex(0);
    else if(kraftstoff=="Super") ui->comboBox->setCurrentIndex(1);
    else if(kraftstoff=="SuperPlus") ui->comboBox->setCurrentIndex(2);
    else if(kraftstoff=="SuperE5") ui->comboBox->setCurrentIndex(3);
    else if(kraftstoff=="Autogas") ui->comboBox->setCurrentIndex(4);
    else if(kraftstoff=="Erdgas") ui->comboBox->setCurrentIndex(5);
    else if(kraftstoff=="Biodiesel") ui->comboBox->setCurrentIndex(6);
    else if(kraftstoff=="LKW-Diesel") ui->comboBox->setCurrentIndex(7);
    else{
        ui->comboBox->setCurrentIndex(0);
        default_kraftstoff="Diesel";
    }

    switch(radius){
    case 1: ui->comboBox_2->setCurrentIndex(0);
        break;
    case 2: ui->comboBox_2->setCurrentIndex(1);
        break;
    case 3: ui->comboBox_2->setCurrentIndex(2);
        break;
    case 5: ui->comboBox_2->setCurrentIndex(3);
        break;
    case 10: ui->comboBox_2->setCurrentIndex(4);
        break;
    case 15: ui->comboBox_2->setCurrentIndex(5);
        break;
    case 25: ui->comboBox_2->setCurrentIndex(6);
        break;
    case 35: ui->comboBox_2->setCurrentIndex(7);
        break;
    case 50: ui->comboBox_2->setCurrentIndex(8);
        break;
    case 75: ui->comboBox_2->setCurrentIndex(9);
        break;
    case 100: ui->comboBox_2->setCurrentIndex(10);
        break;
    default: ui->comboBox_2->setCurrentIndex(4);
        default_radius=10;
    }
}

Einstellungen::~Einstellungen()
{
    delete ui;
}



void Einstellungen::on_comboBox_activated(int index)
{
    if(index==0) default_kraftstoff="Diesel";
    else if(index==1) default_kraftstoff="Super";
    else if(index==2) default_kraftstoff="SuperPlus";
    else if(index==3) default_kraftstoff="SuperE5";
    else if(index==4) default_kraftstoff="Autogas";
    else if(index==5) default_kraftstoff="Erdgas";
    else if(index==6) default_kraftstoff="Biodiesel";
    else default_kraftstoff="LKW-Diesel";

}

int Einstellungen::getUmkreis(){
    return default_radius;
}
QString Einstellungen::getKraftstoff(){
    return default_kraftstoff;
}

void Einstellungen::on_comboBox_2_activated(QString rad)
{
    default_radius=rad.toInt();
}
