#include "clevertanken.h"
#include "tankstelle.h"

CleverTanken::CleverTanken(QObject *parent) :
    QObject(parent)
{
    manager = new QNetworkAccessManager();
    manager2 = new QNetworkAccessManager();
    connect(manager,SIGNAL(finished(QNetworkReply*)),this,SLOT(replyFinished(QNetworkReply*)));
    connect(manager2,SIGNAL(finished(QNetworkReply*)),this,SLOT(foundSearchUrl(QNetworkReply*)));
}

void CleverTanken::replyFinished(QNetworkReply *rply){
    if(rply->error()==QNetworkReply::NoError){
        QString tmp = rply->readAll();
        tmp = tmp.replace("&amp;","&").section("\"",1,1);
        //qDebug()<<tmp;
        manager2->get(QNetworkRequest(QUrl(tmp)));
    }
    else {
        emit foundError(rply->errorString());
    }
}
void CleverTanken::foundSearchUrl(QNetworkReply *rply){
    if(rply->error()==QNetworkReply::NoError){
        Tankstelle tmptank;
        QList<Tankstelle> tankstellen;

        QString tmp = rply->readAll();
        QStringList zeilen;
        QStringList spalten;
        QStringList tmplist;

        if(tmp.contains("showtank")){
            tmp.remove(0,tmp.indexOf("<TABLE BORDER=0"));
            tmp.remove(tmp.indexOf("</table>"),tmp.size()-tmp.indexOf("</table>"));
            tmp.remove("<tr>",Qt::CaseInsensitive);
            zeilen = tmp.split("</tr>",QString::SkipEmptyParts,Qt::CaseInsensitive);
        }
        if(zeilen.size()>5){
            zeilen.removeFirst();
            zeilen.removeFirst();
            zeilen.removeFirst();
            zeilen.removeLast();
            zeilen.removeLast();
            for(int i=0;i<zeilen.size();i++){
                spalten = zeilen[i].split("</td>",QString::SkipEmptyParts,Qt::CaseInsensitive);
                if(spalten.size()==12){
                    for(int j=0;j<4;j++){
                        spalten.removeFirst();
                        spalten.removeLast();
                    }
                    spalten.removeAt(1);
                    tmptank.url.setUrl("http://www.clever-tanken.de/"+spalten[0].mid(spalten[0].indexOf("showtank"),spalten[0].lastIndexOf("\"")-spalten[0].indexOf("showtank")));
                    spalten[0] = spalten[0].replace("<br>","{br}");
                    spalten[0] = spalten[0].replace("&nbsp;", " ");
                    spalten[0]= spalten[0].remove(QRegExp("<[^<>]+>")).simplified();
                    tmplist = spalten[0].split("{br}",QString::SkipEmptyParts);
                    if(tmplist.size()==3){
                        tmptank.name = tmplist[0];
                        tmptank.str = tmplist[1];
                        tmplist = tmplist[2].split(" ",QString::SkipEmptyParts);
                        if(tmplist.size()==2){
                            tmptank.plz = tmplist[0];
                            tmptank.ort = tmplist[1];
                        }

                    }

                    tmptank.preis = spalten[1].remove(QRegExp("<[^<>]+>")).simplified();
                    tmplist = spalten[2].remove(QRegExp("<[^<>]+>")).simplified().split(" ",QString::SkipEmptyParts);
                    if(tmplist.size()==2){
                        tmptank.update_datum = QDate::fromString(tmplist[0],"dd.MM.yyyy");
                        tmptank.update_time = QTime::fromString(tmplist[1],"hh:mm:ss");
                    }
                    tankstellen.append(tmptank);
                    tmptank.clear();
                }
            }
        }
        emit tankstellenFounded(tankstellen);
    }
    else{
        emit foundError(rply->errorString());
    }
}

void CleverTanken::sucheTankstellen(QString plz, QString ort, QString str_hsnr, int radius, QString kraftstoff, QString land){
    if(radius<1) radius=1;
    if(radius>100) radius = 100;
    QByteArray tmp = QString("target=www.clever-tanken.de&suche=1&start_plz="+plz+"&start_ort="+ort.replace(QRegExp("\\s+"),"+")+"&start_str="+str_hsnr.replace(QRegExp("\\s+"),"+")+"&umkreis_radius="+QString().number(radius)+"&sprittyp="+kraftstoff+"&start_land="+land).toAscii();
    manager->post(QNetworkRequest(QUrl("http://www2.clever-tanken.de/map/check_location_redirect.asp")),tmp);
}
