/* speedy.c generated by valac, the Vala compiler
 * generated from speedy.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <hildon/hildon.h>
#include <gtk/gtk.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>


#define TYPE_SPEEDY (speedy_get_type ())
#define SPEEDY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SPEEDY, Speedy))
#define SPEEDY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SPEEDY, SpeedyClass))
#define IS_SPEEDY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SPEEDY))
#define IS_SPEEDY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SPEEDY))
#define SPEEDY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SPEEDY, SpeedyClass))

typedef struct _Speedy Speedy;
typedef struct _SpeedyClass SpeedyClass;
typedef struct _SpeedyPrivate SpeedyPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _Speedy {
	HildonProgram parent_instance;
	SpeedyPrivate * priv;
};

struct _SpeedyClass {
	HildonProgramClass parent_class;
};

struct _SpeedyPrivate {
	HildonWindow* window;
	HildonButton* button;
	GtkLabel* speedLabel;
	GtkLabel* helpLabel;
	GtkProgressBar* bar;
	GTimer* timer;
	SoupSession* session;
	gboolean started;
	gint64 contentLength;
	gint64 bytesReceived;
};


static gpointer speedy_parent_class = NULL;

GType speedy_get_type (void);
#define SPEEDY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SPEEDY, SpeedyPrivate))
enum  {
	SPEEDY_DUMMY_PROPERTY
};
#define SPEEDY_downloadUrl "http://news.bbc.co.uk/nol/shared/spl/hi/uk/08/broad_band_britain/swf/download.jpg"
static void speedy_doDownload (Speedy* self);
static void speedy_toggleDownload (Speedy* self);
static void _lambda0_ (SoupMessage* msg, Speedy* self);
static void __lambda0__soup_message_got_headers (SoupMessage* _sender, gpointer self);
static void speedy_gotChunk (Speedy* self, SoupMessage* msg, SoupBuffer* buf);
static void _speedy_gotChunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self);
static void speedy_run (Speedy* self);
Speedy* speedy_new (void);
Speedy* speedy_construct (GType object_type);
static gint speedy_main (char** args, int args_length1);
static void _gtk_main_quit_gtk_object_destroy (HildonWindow* _sender, gpointer self);
static void _lambda1_ (GtkButton* source, Speedy* self);
static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * speedy_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void speedy_finalize (GObject* obj);



static void speedy_toggleDownload (Speedy* self) {
	g_return_if_fail (self != NULL);
	if (!self->priv->started) {
		self->priv->started = TRUE;
		hildon_button_set_title (self->priv->button, "Stop");
		gtk_label_set_label (self->priv->helpLabel, "Downloading, hold on...");
		speedy_doDownload (self);
	} else {
		SoupSession* _tmp0_;
		self->priv->started = FALSE;
		hildon_button_set_title (self->priv->button, "Start");
		gtk_label_set_label (self->priv->helpLabel, "Click the start button to measure again.");
		if (self->priv->session != NULL) {
			soup_session_abort (self->priv->session);
		}
		g_timer_stop (self->priv->timer);
		self->priv->session = (_tmp0_ = NULL, _g_object_unref0 (self->priv->session), _tmp0_);
	}
}


static void _lambda0_ (SoupMessage* msg, Speedy* self) {
	g_return_if_fail (msg != NULL);
	g_timer_start (self->priv->timer);
	self->priv->contentLength = soup_message_headers_get_content_length (msg->response_headers);
}


static void __lambda0__soup_message_got_headers (SoupMessage* _sender, gpointer self) {
	_lambda0_ (_sender, self);
}


static void _speedy_gotChunk_soup_message_got_chunk (SoupMessage* _sender, SoupBuffer* chunk, gpointer self) {
	speedy_gotChunk (self, _sender, chunk);
}


static void speedy_doDownload (Speedy* self) {
	SoupSession* _tmp0_;
	SoupMessage* message;
	g_return_if_fail (self != NULL);
	self->priv->session = (_tmp0_ = (SoupSession*) ((SoupSessionAsync*) soup_session_async_new ()), _g_object_unref0 (self->priv->session), _tmp0_);
	message = soup_message_new ("GET", SPEEDY_downloadUrl);
	g_signal_connect_object (message, "got-headers", (GCallback) __lambda0__soup_message_got_headers, self, 0);
	g_signal_connect_object (message, "got-chunk", (GCallback) _speedy_gotChunk_soup_message_got_chunk, self, 0);
	self->priv->contentLength = (gint64) 0;
	self->priv->bytesReceived = (gint64) 0;
	gtk_progress_bar_set_fraction (self->priv->bar, 0.0);
	soup_session_send_message (self->priv->session, message);
	_g_object_unref0 (message);
}


static void speedy_gotChunk (Speedy* self, SoupMessage* msg, SoupBuffer* buf) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (buf != NULL);
	self->priv->bytesReceived = self->priv->bytesReceived + ((gint64) buf->length);
	gtk_progress_bar_set_fraction (self->priv->bar, (double) (self->priv->bytesReceived / ((float) self->priv->contentLength)));
	gtk_label_set_label (self->priv->speedLabel, _tmp0_ = g_strdup_printf ("%.2f KB/s", (self->priv->bytesReceived / 1024) / g_timer_elapsed (self->priv->timer, NULL)));
	_g_free0 (_tmp0_);
	if (self->priv->bytesReceived >= self->priv->contentLength) {
		speedy_toggleDownload (self);
	}
}


static void speedy_run (Speedy* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self->priv->window);
	gtk_main ();
}


static gint speedy_main (char** args, int args_length1) {
	gint result;
	Speedy* _tmp0_;
	gtk_init (&args_length1, &args);
	if (!g_thread_supported ()) {
		g_error ("speedy.vala:123: Cannot run without thread support.");
	}
	speedy_run (_tmp0_ = speedy_new ());
	_g_object_unref0 (_tmp0_);
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return speedy_main (argv, argc);
}


Speedy* speedy_construct (GType object_type) {
	Speedy * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


Speedy* speedy_new (void) {
	return speedy_construct (TYPE_SPEEDY);
}


static void _gtk_main_quit_gtk_object_destroy (HildonWindow* _sender, gpointer self) {
	gtk_main_quit ();
}


static void _lambda1_ (GtkButton* source, Speedy* self) {
	g_return_if_fail (source != NULL);
	speedy_toggleDownload (self);
}


static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static GObject * speedy_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Speedy * self;
	parent_class = G_OBJECT_CLASS (speedy_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SPEEDY (obj);
	{
		HildonWindow* _tmp0_;
		GtkVBox* box;
		GtkLabel* _tmp1_;
		PangoFontDescription* d;
		GtkProgressBar* _tmp2_;
		GtkLabel* _tmp3_;
		HildonButton* _tmp4_;
		GTimer* _tmp5_;
		self->priv->window = (_tmp0_ = g_object_ref_sink ((HildonWindow*) hildon_window_new ()), _g_object_unref0 (self->priv->window), _tmp0_);
		hildon_program_add_window ((HildonProgram*) self, self->priv->window);
		g_signal_connect ((GtkObject*) self->priv->window, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
		g_set_application_name ("Speedy");
		box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 1));
		gtk_container_set_border_width ((GtkContainer*) box, (guint) 10);
		self->priv->speedLabel = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("0.00 KB/s")), _g_object_unref0 (self->priv->speedLabel), _tmp1_);
		d = pango_font_description_new ();
		pango_font_description_set_size (d, 48000);
		gtk_widget_modify_font ((GtkWidget*) self->priv->speedLabel, d);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->speedLabel, TRUE, TRUE, (guint) 0);
		self->priv->bar = (_tmp2_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->bar), _tmp2_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->bar, FALSE, TRUE, (guint) 10);
		self->priv->helpLabel = (_tmp3_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("Click the button to start measuring.")), _g_object_unref0 (self->priv->helpLabel), _tmp3_);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->helpLabel, FALSE, FALSE, (guint) 10);
		self->priv->button = (_tmp4_ = g_object_ref_sink ((HildonButton*) hildon_button_new (HILDON_SIZE_THUMB_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL)), _g_object_unref0 (self->priv->button), _tmp4_);
		hildon_button_set_title (self->priv->button, "Start");
		g_signal_connect_object ((GtkButton*) self->priv->button, "clicked", (GCallback) __lambda1__gtk_button_clicked, self, 0);
		gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->button, FALSE, FALSE, (guint) 10);
		self->priv->timer = (_tmp5_ = g_timer_new (), _g_timer_destroy0 (self->priv->timer), _tmp5_);
		gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) box);
		_g_object_unref0 (box);
		_pango_font_description_free0 (d);
	}
	return obj;
}


static void speedy_class_init (SpeedyClass * klass) {
	speedy_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SpeedyPrivate));
	G_OBJECT_CLASS (klass)->constructor = speedy_constructor;
	G_OBJECT_CLASS (klass)->finalize = speedy_finalize;
}


static void speedy_instance_init (Speedy * self) {
	self->priv = SPEEDY_GET_PRIVATE (self);
	self->priv->started = FALSE;
	self->priv->contentLength = (gint64) 0;
	self->priv->bytesReceived = (gint64) 0;
}


static void speedy_finalize (GObject* obj) {
	Speedy * self;
	self = SPEEDY (obj);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->button);
	_g_object_unref0 (self->priv->speedLabel);
	_g_object_unref0 (self->priv->helpLabel);
	_g_object_unref0 (self->priv->bar);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->session);
	G_OBJECT_CLASS (speedy_parent_class)->finalize (obj);
}


GType speedy_get_type (void) {
	static GType speedy_type_id = 0;
	if (speedy_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (SpeedyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) speedy_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Speedy), 0, (GInstanceInitFunc) speedy_instance_init, NULL };
		speedy_type_id = g_type_register_static (HILDON_TYPE_PROGRAM, "Speedy", &g_define_type_info, 0);
	}
	return speedy_type_id;
}




