/*
 * Acceleration start dialog
 *
 * @author      Jukka Kurttila  <jukka.kurttila@fudeco.com>
 * @author      Toni Jussila 	<toni.jussila@fudeco.com>
 * @copyright   (c) 2010 Speed Freak team
 * @license     http://opensource.org/licenses/gpl-license.php GNU Public License
 */

#include "accelerationstart.h"
#include "ui_accelerationstartdialog.h"
#include <QMessageBox>
#include <QDebug>

/**
  * Constructor of this class.
  */
accelerationstart::accelerationstart(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::accelerationstart)
{
    ui->setupUi(this);
    ui->buttonStart->setDisabled(true);

    accRealTimeDialog = NULL;
    helpAccelerationDialog = NULL;

    stopMeasureSpeed = 0;

    ui->categorComboBox->addItem("Select category");
    ui->categorComboBox->addItem("0 - 20 km/h",20);
    ui->categorComboBox->addItem("0 - 40 km/h");
    ui->categorComboBox->addItem("0 - 100 km/h");

    //Button settings
    ui->buttonCalib->setAutoFillBackground(true);
    ui->buttonCalib->setStyleSheet("background-color: rgb(0, 0, 0); color: rgb(255, 255, 255)");
    ui->buttonStart->setAutoFillBackground(true);
    ui->buttonStart->setStyleSheet("background-color: rgb(0, 0, 0); color: rgb(255, 255, 255)");
    ui->pushButtonInfo->setAutoFillBackground(true);
    ui->pushButtonInfo->setStyleSheet("background-color: rgb(0, 0, 0); color: rgb(255, 255, 255)");
}

/**
  * Destructor of this class.
  * Deletes all dynamic objects and sets them to NULL.
  */
accelerationstart::~accelerationstart()
{
    delete ui;
    if(accRealTimeDialog)
        delete accRealTimeDialog;
}

/**
  *
  */
void accelerationstart::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/**
  * This slot function called when ever calibration button clicked
  */
void accelerationstart::on_buttonCalib_clicked()
{
    if(accRealTimeDialog == NULL)
        accRealTimeDialog = new AccRealTimeDialog(this);

    connect(accRealTimeDialog, SIGNAL(sendresult(double)), this, SLOT(sendResult(double)));

    accRealTimeDialog->Calibrate();

    ui->buttonStart->setEnabled(true);
}

/**
  * This slot function called when ever start button clicked
  */
void accelerationstart::on_buttonStart_clicked()
{
    if( stopMeasureSpeed == 0 )
    {
        QMessageBox msgBox;
        msgBox.setWindowTitle("Can not start measure!");
        msgBox.setText("Select category first!");
        msgBox.setDefaultButton(QMessageBox::Ok);
        msgBox.exec();
        return;
    }
    accRealTimeDialog->SetStopMeasureSpeed( stopMeasureSpeed );
    accRealTimeDialog->startAccelerationMeasure();
    accRealTimeDialog->show();
}

/**
  * This slot function called when ever category combobox index changed.
  *
  * @param int index
  */
void accelerationstart::on_categorComboBox_currentIndexChanged( int index )
{
    stopMeasureSpeed = 0;
    if( index == 1 ) {
        stopMeasureSpeed = 20;
        measureCategory = "acceleration-0-20";
    }
    else if( index == 2 ) {
        stopMeasureSpeed = 40;
        measureCategory = "acceleration-0-40";
    }
    else if( index == 3 ) {
        stopMeasureSpeed = 100;
        measureCategory = "acceleration-0-100";
    }
}

/**
  * Get measure categoty function.
  *
  * @return QString measure category
  */
QString accelerationstart::getMeasureCategory()
{
    return measureCategory;
}

/**
  *This slot function emit mainwindow sendresult.
  *
  * @param double result
  */
void accelerationstart::sendResult(double result)
{
    emit sendresult(measureCategory, result);
}

/**
  * This slot function called when ever info button clicked.
  */
void accelerationstart::on_pushButtonInfo_clicked()
{
    if(!helpAccelerationDialog)
    {
        helpAccelerationDialog = new HelpAccelerationDialog;
    }
    connect(helpAccelerationDialog, SIGNAL(rejected()), this, SLOT(killHelpDialog()));
    helpAccelerationDialog->show();
}

/**
  * This slot function called when ever dialog rejected.
  */
void accelerationstart::killHelpDialog()
{
    if(helpAccelerationDialog)
    {
        qDebug() << "__Acc kill: helpAccelerationDialog";
        delete helpAccelerationDialog;
        helpAccelerationDialog = NULL;
    }
}
