/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.base;

import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.helpers.QueryModelTreePrinter;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;
import org.openrdf.sail.rdbms.algebra.base.UnarySqlOperator;
import org.openrdf.sail.rdbms.optimizers.SqlConstantOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinarySqlOperator
extends RdbmsQueryModelNodeBase
implements SqlExpr {
    private SqlExpr leftArg;
    private SqlExpr rightArg;

    public BinarySqlOperator() {
    }

    public BinarySqlOperator(SqlExpr leftArg, SqlExpr rightArg) {
        this.setLeftArg(leftArg);
        this.setRightArg(rightArg);
    }

    public SqlExpr getLeftArg() {
        return this.leftArg;
    }

    public void setLeftArg(SqlExpr leftArg) {
        this.leftArg = leftArg;
        leftArg.setParentNode(this);
    }

    public SqlExpr getRightArg() {
        return this.rightArg;
    }

    public void setRightArg(SqlExpr rightArg) {
        this.rightArg = rightArg;
        rightArg.setParentNode(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        this.leftArg.visit(visitor);
        this.rightArg.visit(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.leftArg == current) {
            this.setLeftArg((SqlExpr)replacement);
        } else if (this.rightArg == current) {
            this.setRightArg((SqlExpr)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public BinarySqlOperator clone() {
        BinarySqlOperator clone = (BinarySqlOperator)super.clone();
        clone.setLeftArg(this.leftArg.clone());
        clone.setRightArg(this.rightArg.clone());
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftArg == null ? 0 : this.leftArg.hashCode());
        result = 31 * result + (this.rightArg == null ? 0 : this.rightArg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinarySqlOperator other = (BinarySqlOperator)obj;
        if (this.leftArg == null ? other.leftArg != null : !this.leftArg.equals(other.leftArg)) {
            return false;
        }
        return !(this.rightArg == null ? other.rightArg != null : !this.rightArg.equals(other.rightArg));
    }

    @Override
    public String toString() {
        QueryModelTreePrinter treePrinter = new QueryModelTreePrinter();
        BinarySqlOperator clone = this.clone();
        UnarySqlOperator parent = new UnarySqlOperator(clone){

            @Override
            public <X extends Exception> void visit(RdbmsQueryModelVisitorBase<X> visitor) throws X {
                visitor.meetOther(this);
            }
        };
        new SqlConstantOptimizer().optimize(clone);
        parent.getArg().visit(treePrinter);
        return treePrinter.getTreeString();
    }
}

