import radio_modules as rm
import spatial_placement


def combine_meas(dev_results, devices):
    final_results = {}
    for dev in devices:
        for v in dev_results[dev]:
            if v in final_results:
                continue
            else:

                #filter out matching results
                matching_devices = {}
                for other_dev in devices:
                    if v in dev_results[other_dev]:
                        matching_devices[other_dev] = \
                        dev_results[other_dev][v]

                #compute mean
                mean = 0.0
                for d in matching_devices:
                    mean = mean + matching_devices[d][0]
                mean = mean / len(matching_devices)

                #compute unc
                unc = {}
                for d in matching_devices:
                    unc[d] = \
                    matching_devices[d][2] - matching_devices[d][1]

                #compute pull
                pull = {}
                for d in matching_devices:
                    pull[d] = (mean - matching_devices[d][0]) * unc[d]

                #final estimate
                total_pull = 0.0
                total_unc = 0.0
                for d in matching_devices:
                    total_pull = total_pull + pull[d]
                    total_unc = total_unc + unc[d]

                if total_unc != 0:
                    final_results[v] = mean + total_pull / total_unc
                else:
                    final_results[v] = mean

    return final_results


class Localization:

    def scan(self):
        dev_results = {}
        learned_ng = {}
        for dev in self.devices:
            dev_results[dev], dev_ng = dev.scan()
            print dev_results[dev]
            for k, v in dev_ng.iteritems():
                learned_ng[k] = v
        ng = learned_ng
        ng[self._ID] = combine_meas(dev_results, self.devices)
        return ng

    def update(self):

        if len(self.devices) == 0:
            print "No devices initialized"
            return

        newNeighbors = self.scan()
        for dev in self.devices:
            #broadcast 1-hop neighbors on each device
            dev.setIdentifier(newNeighbors[self._ID])

        neighbors = self.neighborHistory[-1].copy()
        self.neighborHistory.append(newNeighbors)
        neighbors.update(newNeighbors)
        layout = spatial_placement.build_layout(neighbors, self._ID)
        return layout

    def __init__(self, ID):
        ID = rm.sanitize_peer_id(ID)
        self._ID = ID

        self.devices = []
        self.neighborHistory = [{}]
        try:
            dev_bt = rm.BT_Module(ID)
            print "Bluetooth interface found"
            dev_bt.turnOn()
            self.devices.append(dev_bt)
        except rm.DeviceNotFoundError, e:
            print "Bluetooth interface not found", e

        try:
            dev_wifi = rm.WIFI_Module(ID)
            print "Wifi interface found"
            dev_wifi.turnOn()
            self.devices.append(dev_wifi)
        except rm.DeviceNotFoundError, e:
            print "Wifi interface not found", e
