import radio_modules
import spatial_placement


def combine_meas(dev_results, devices):
    final_results = {}
    for dev in devices:
        for v in dev_results[dev]:
            if v in final_results:
                continue
            else:

                #filter out matching results
                matching_devices = {}
                for other_dev in devices:
                    if v in dev_results[other_dev]:
                        matching_devices[other_dev] = \
                        dev_results[other_dev][v]

                #compute mean
                mean = 0.0
                for d in matching_devices:
                    mean = mean + matching_devices[d][0]
                mean = mean / len(matching_devices)

                #compute unc
                unc = {}
                for d in matching_devices:
                    unc[d] = \
                    matching_devices[d][2] - matching_devices[d][1]

                #compute pull
                pull = {}
                for d in matching_devices:
                    pull[d] = (mean - matching_devices[d][0]) * unc[d]

                #final estimate
                total_pull = 0.0
                total_unc = 0.0
                for d in matching_devices:
                    total_pull = total_pull + pull[d]
                    total_unc = total_unc + unc[d]

                if total_unc != 0:
                    final_results[v] = mean + total_pull / total_unc
                else:
                    final_results[v] = mean

    return final_results


class Localization:

    def scan(self):
        dev_results = {}
        learned_ng = {}
        for dev in self.devices:
            dev_results[dev], dev_ng = dev.scan()
            print dev_results[dev]
            for k, v in dev_ng.iteritems():
                learned_ng[k] = v
        ng = learned_ng
        ng[self._ID] = combine_meas(dev_results, self.devices)
        return ng

    def update(self):
        neighbors = self.scan()
        for dev in self.devices:
            dev.setIdentifier(neighbors[self._ID]) #broadcast 1-hop neighbors

        layout = spatial_placement.build_system(neighbors, self._ID)
        return layout

    def __init__(self, ID):
        ID = radio_modules.sanitize_peer_id(ID)
        self._ID = ID

        self.devices = []
        try:
            dev_bt = radio_modules.BT_Module(ID)
            print "Bluetooth interface found"
            dev_bt.turnOn()
            self.devices.append(dev_bt)
        except OSError:
            pass

        try:
            dev_wifi = radio_modules.WIFI_Module(ID)
            print "Wifi interface found"
            dev_wifi.turnOn()
            self.devices.append(dev_wifi)
        except OSError:
            pass
