#ifndef NOTEWINDOW_H
#define NOTEWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QTextEdit>
#include <QCloseEvent>
#include <qfacebook.h>
#include <QMessageBox>
#ifdef Q_WS_MAEMO_5
    #include "texteditautoresizer.h"
#endif

namespace Ui {
    class NoteWindow;
}

class NoteWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit NoteWindow(QWidget *parent = 0, QString accessToken = "0");
    ~NoteWindow();
    void showNote(QString noteId);
    QTextEdit* textEdit();
    void setCreateMode(QString subject, QString id);

protected:
    void closeEvent(QCloseEvent *);

private:
    Ui::NoteWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString m_noteId;
    QString m_subjectText;
    QString m_toWallId;
    bool isCreateMode;
    bool isEditMode;

private slots:
    void onReplyReceived();
    void onNotePosted();
    void onEditTriggered();
};

#endif // NOTEWINDOW_H
