#include "newstatusupdatedialog.h"
#include "ui_newstatusupdatedialog.h"

NewStatusUpdateDialog::NewStatusUpdateDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NewStatusUpdateDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    ui->videoEdit->hide();
    ui->linkEdit->hide();
    QPushButton *addLink = new QPushButton(tr("Attach link"), this);
    QPushButton *addVideo = new QPushButton(tr("Attach video"), this);
    connect(addLink, SIGNAL(clicked()), ui->linkEdit, SLOT(show()));
    connect(addVideo, SIGNAL(clicked()), ui->videoEdit, SLOT(show()));
    ui->buttonBox->addButton(addLink, QDialogButtonBox::ActionRole);
    ui->buttonBox->addButton(addVideo, QDialogButtonBox::ActionRole);
}

NewStatusUpdateDialog::~NewStatusUpdateDialog()
{
    delete ui;
}

void NewStatusUpdateDialog::accept()
{
    emit postUpdate(ui->textEdit->toPlainText(), ui->linkEdit->text(), ui->videoEdit->text());
    this->close();
}
