/**************************************************************************
    This file is part of Sociality
    Copyright (C) 2011 Mohammad Abu-Garbeyyeh

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

#include "thumbnailitemdelegate.h"

void ThumbnailItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
    QString text = index.data(Qt::DisplayRole).toString();
    QPixmap thumbnail = QIcon(index.data(Qt::DecorationRole).value<QIcon>()).pixmap(128, 128);

    painter->save();
    QRect r = option.rect;
    if (option.state & QStyle::State_Selected) {
        r = option.rect;
#ifdef Q_WS_MAEMO_5
        painter->drawImage(r, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
#else
        painter->fillRect(r, option.palette.highlight().color());
#endif
    }
    QFont f = painter->font();
    f.setPointSize(13);
    painter->setFont(f);
    QPen defaultPen = painter->pen();
    QColor gray;
    gray = QColor(156, 154, 156);

    r = option.rect;
    painter->drawPixmap(r.x() + ((r.width()/2)-(128/2)), r.y(), 128, 128, thumbnail);

    r = option.rect;
    r.setLeft(r.left()+10);
    r.setRight(r.right()-10);
    painter->setPen(QColor(Qt::black));
#ifdef Q_WS_MAEMO_5
    f.setBold(true);
    painter->setFont(f);
#endif
    painter->drawText(r.x(), r.y()+133, r.width(), r.height(), Qt::AlignHCenter, text, &r);

    r = option.rect;
#ifdef Q_WS_MAEMO_5
    f.setBold(false);
    painter->setFont(f);
#endif
    if (!index.data(Qt::UserRole).toString().startsWith("profile://")) {
        int badge_size = 50;

        QRadialGradient redGradient = QRadialGradient(0.0, 0.0, 17.0, badge_size-3, badge_size-3);
        redGradient.setColorAt(0.0, QColor(229, 79, 86));
        redGradient.setColorAt(0.5, QColor(255, 0, 0));
        redGradient.setColorAt(1.0, QColor(220, 12, 0));

        int badge_counter = index.data(Qt::UserRole).toInt();
        QPoint point = option.rect.topRight();
        painter->setRenderHints(QPainter::Antialiasing|QPainter::TextAntialiasing);
        painter->setBrush(redGradient);

        if (badge_counter > 0)
            this->drawBadge(painter, point.x()-badge_size-1, point.y()+1, badge_size,
                            QString::number(badge_counter), QBrush(redGradient));
        painter->setPen(defaultPen);
    }

    painter->restore();
}

void ThumbnailItemDelegate::drawBadge(QPainter *painter, int x, int y, int size, QString text, QBrush brush) const
{
    painter->setFont(QFont(painter->font().family(), 11, QFont::Bold));

    while ((size - painter->fontMetrics().width(text)) < 10) {
        int pointSize = painter->font().pointSize() - 1;
        QFont::Weight weight;
        if (pointSize < 8)
            weight = QFont::Normal;
        else
            weight = QFont::Bold;
        painter->setFont(QFont(painter->font().family(), painter->font().pointSize()-1, weight));
    }

    QColor shadowColor = QColor(0, 0, 0, size);
    this->fillEllipse(painter, x + 1, y, size, shadowColor);
    this->fillEllipse(painter, x - 1, y, size, shadowColor);
    this->fillEllipse(painter, x, y + 1, size, shadowColor);
    this->fillEllipse(painter, x, y - 1, size, shadowColor);

    painter->setPen(QPen(Qt::white, 2));
    this->fillEllipse(painter, x, y, size - 3, brush);
    painter->drawEllipse(x, y, size - 3, size - 3);

    painter->setPen(QPen(Qt::white, 1));
    painter->drawText(x, y, size - 2, size - 2, Qt::AlignCenter, text);
}

void ThumbnailItemDelegate::fillEllipse(QPainter *painter, int x, int y, int size, QBrush brush) const
{
    QPainterPath path;
    path.addEllipse(x, y, size, size);
    painter->fillPath(path, brush);
}

QSize ThumbnailItemDelegate::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
{
    return QSize(155, 180);
}
