#include "qanimatedlabel.h"

QAnimatedLabel::QAnimatedLabel(QWidget *parent) :
    QLabel(parent)
{
    /*
    m_animation = new QPropertyAnimation(this, "pos", this);
    m_animation->setStartValue(QPoint(x(), y()-(height()+70)));
    m_animation->setEndValue(pos());
    m_animation->setDuration(1000);
    */

    QGraphicsOpacityEffect *effect = new QGraphicsOpacityEffect(this);
    setGraphicsEffect(effect);

    m_animation = new QPropertyAnimation(effect, "opacity", this);
    m_animation->setStartValue(0.0);
    m_animation->setEndValue(1.0);
    m_animation->setDuration(300);
    m_animation->setEasingCurve(QEasingCurve::InOutBack);
}

void QAnimatedLabel::setPixmap(const QPixmap &pixmap)
{
    QLabel::setPixmap(pixmap);

    m_animation->start();
}
