#include "messageswindow.h"
#include "ui_messageswindow.h"

MessagesWindow::MessagesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::MessagesWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    this->updateMessages();
    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        QPalette p(palette());
        p.setColor(QPalette::Background, QColor(220, 225, 235));
        setPalette(p);
    }
}

MessagesWindow::~MessagesWindow()
{
    delete ui;
}

void MessagesWindow::updateMessages()
{
    this->reply = qfacebook->getConnections("me", "inbox");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void MessagesWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-10);
}

void MessagesWindow::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch messages!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    foreach (NewsFeedPost *message, messages) {
        ui->scrollLayout->removeWidget(message);
        messages.removeOne(message);
        delete message;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *item = new NewsFeedPost(this, accessToken, qfacebook, nam);
        item->setMessageMode(true);
        /* Messages are readonly for now... */
        // item->setDeletable(true);
        connect(item, SIGNAL(clicked(QString)), this, SLOT(onMessageClicked(QString)));
        connect(item, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        QVariantList names = jsonData.toMap().value("to").toMap().value("data").toList();
        QVariant name;
        QString from;
        QString myid =  QSettings().value("main/myId").toString();
        foreach(name, names) {
            if(name.toMap().value("id").toString() != myid) {
                from.append(name.toMap().value("name").toString());
                if(name != names.last())
                    from.append(tr(", "));
            }
        }
	
//        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        QString id = jsonData.toMap().value("id").toString();
        QVariantList comments = jsonData.toMap().value("comments").toMap().value("data").toList();
        QVariant comment;
        QString time = jsonData.toMap().value("updated_time").toString();
        QString message;
        foreach(comment, comments) {
            if(comment.toMap().value("created_time").toString() == time)
                message = comment.toMap().value("message").toString();
        }
        if (message.size() > 100) {
            message.truncate(100);
            message.append("...");
        }
//        item->setUserId(userId);
        item->setName(from);
        item->setMessage(message);
        item->setTime(time);
//        item->getPixmapFromUrl(QString("https://graph.facebook.com/%1/picture&access_token=%2").arg(userId, accessToken));
        item->setId(id);
        ui->scrollLayout->addWidget(item);
        messages.append(item);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void MessagesWindow::onMessageClicked(QString id)
{
    MessageView *message = new MessageView(this, this->accessToken);
    message->parseMessageById(id);
#ifdef Q_WS_S60
    message->showMaximized();
#else
    message->show();
#endif
}

void MessagesWindow::onNewMessageButtonClicked()
{
    ComposeMessage *messageComposer = new ComposeMessage(this, this->accessToken);
#ifdef Q_WS_S60
    messageComposer->showMaximized();
#else
    messageComposer->show();
#endif
}

void MessagesWindow::onNameClicked(QString id, QString name)
{
    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->browseProfile(id);
    profile->setWindowTitle(name);
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}
