#include "qclickablelabel.h"

QClickableLabel::QClickableLabel(QWidget *parent) :
    QLabel(parent)
{
}

void QClickableLabel::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void QClickableLabel::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked();
            emit clickedPos(ev->pos());
        }
    }
}

bool QClickableLabel::isPressed()
{
    return m_pressed;
}

void QClickableLabel::setData(QVariant data)
{
    this->variant = data;
}

QVariant QClickableLabel::data()
{
    return variant;
}
