#ifndef PROFILEWINDOW_H
#define PROFILEWINDOW_H

#include <QMainWindow>
#include <QSettings>
#include <QDesktopWidget>
#include <QPointer>
#include <qfacebook.h>
#include "newsfeedpost.h"
#include "newstatusupdatedialog.h"
#include "photowindow.h"
#include "singlepostwindow.h"
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#else
    #include <QMessageBox>
#endif

namespace Ui {
    class ProfileWindow;
}

class ProfileWindow : public QMainWindow
{
    Q_OBJECT

public:
    enum ProfileTypes {FriendProfile,
                       GroupProfile};
    explicit ProfileWindow(QWidget *parent = 0, QString token = "0", ProfileTypes profileType = FriendProfile, bool deleteOnClose = true);
    ~ProfileWindow();
    void browseProfile(QString id);

private:
    Ui::ProfileWindow *ui;
    QString profileId;
    QFacebook *qfacebook;
    QPointer<QFacebookReply> reply;
    QPointer<QFacebookReply> infoReply;
    QPointer<QFacebookReply> postReply;
    QPointer<QFacebookReply> friendsReply;
    QString accessToken;
    QNetworkAccessManager *nam;
    //QList<NewsFeedPost*> posts;
    QMap<QString,NewsFeedPost*> posts;
    QPointer<QNetworkReply> avatarReply;
    QByteArray dataToPost;
    QString m_myId;
    bool m_deleteOnClose;
    ProfileTypes m_profileType;
    void setAvatar(QPixmap avatar);
    NewsFeedPost* getPostById(QString id);

private slots:
    void onReplyReceived();
    void onAvatarReceived();
    void onTextBoxClicked();
    void updateProfile();
    void onAvatarClicked();
    void onInfoReplyReceived();
    void orientationChanged();
    void onNameClicked(QString id, QString name);
    void onCommentButtonClicked(QString id, QString comments, QString likes);
    void onNewsFeedPostDestroyed(QObject*);
    void onPhotosClicked();
    void showFriends();
    void onFriendClicked(QListWidgetItem *item);
    void onGotFriendsList();
};

#endif // PROFILEWINDOW_H
