#include <QtGui/QApplication>
#include <QTime>
#include <QSsl>
#include <QSslConfiguration>
#include "mainwindow.h"

int main(int argc, char *argv[])
{
    QApplication::setApplicationName("sociality");
    QApplication::setOrganizationName("MohammadAG");
    QApplication::setApplicationVersion("0.2");
#ifdef Q_WS_MAEMO_5
    QApplication::addLibraryPath("/opt/qtm12/imports");
    QApplication::addLibraryPath("/opt/qtm12/lib");
    QSslConfiguration config = QSslConfiguration::defaultConfiguration();
    config.setProtocol(QSsl::TlsV1);
    QSslConfiguration::setDefaultConfiguration(config);
#endif
    QApplication a(argc, argv);

    QTime t(0,0);
    t.start();
    if (QCoreApplication::arguments().contains("--widget")) {
        // do stuff
    } else {
        MainWindow w;
        qDebug() << "Startup took" << t.elapsed() << "ms";

#ifdef Q_WS_MAEMO_5
        if (!QDBusConnection::sessionBus().isConnected()) {
            qWarning("Cannot connect to the D-Bus session bus.");
        }
#endif

#ifdef Q_WS_S60
        w.showMaximized();
#else
        w.show();
#endif
        return a.exec();
    }
}
