#include "composemessage.h"
#include "ui_composemessage.h"

ComposeMessage::ComposeMessage(QWidget *parent, QString token) :
  QMainWindow(parent),
  ui(new Ui::ComposeMessage),
  qfacebook(new QFacebook(token, this)),
  accessToken(token)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->toButton, SIGNAL(clicked()), this, SLOT(onToClicked()));
}

ComposeMessage::~ComposeMessage()
{
    delete ui;
}

void ComposeMessage::onToClicked()
{
    FriendsWindow *friends = new FriendsWindow(this, this->accessToken);
    friends->setWindowFlags(Qt::Dialog);
    friends->requestRecepientsList();
    connect(friends, SIGNAL(recepientsSelected(QList<QListWidgetItem*>)),
            this, SLOT(onRecepientsListReceived(QList<QListWidgetItem*>)));
}

void ComposeMessage::onRecepientsListReceived(QList<QListWidgetItem*> list)
{
    QStringList recepientNames;
    foreach (QListWidgetItem *item, list) {
        recepients.append(item->data(Qt::UserRole).toString());
        recepientNames.append(item->data(Qt::DisplayRole).toString());
    }
    QString recepientsString = recepientNames.join(", ");
    ui->recepients->setText(recepientsString);
}
