#ifndef SYSTEMNOTIFICATION_H
#define SYSTEMNOTIFICATION_H

#include <QObject>
#include <QDebug>
#include <QSettings>
#include <QMediaPlayer>
#include <QTimer>
#include <QSound>
#ifdef Q_WS_MAEMO_5
    #include <QDBusInterface>
    #include <mce/dbus-names.h>
    #include <q-extras/qemaemo5notification.h>
    #include <profiled/libprofile.h>
#else
    #include <QFeedbackHapticsEffect>
    QTM_USE_NAMESPACE
#endif

class SystemNotification : public QObject
{
    Q_OBJECT

public:
    enum PostTypes {Notification};
    explicit SystemNotification(QObject *parent = 0);
    void createNotification(QString name, QString message, QString icon);
    void vibrate(SystemNotification::PostTypes postType = SystemNotification::Notification);
    void createSoundNotification(int volume = QSettings().value("main/notifications-volume", 100).toInt());

signals:

public slots:
    void clearNotifications();

private:
#ifdef Q_WS_MAEMO_5
    QDBusInterface *m_interface;
#endif
    QList<QObject*> m_notifications;
    QMediaPlayer *m_player;

private slots:
    void onErrorOccured(QMediaPlayer::Error);
};

#endif // SYSTEMNOTIFICATION_H
