#ifndef SINGLEPOSTWINDOW_H
#define SINGLEPOSTWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QSettings>
#include <QDialog>
#include <QListWidget>
#include <QListWidgetItem>
#include <QPointer>
#include <qfacebook.h>
#include "newsfeedpost.h"
#ifndef Q_WS_MAEMO_5
    #include <QMessageBox>
#endif

namespace Ui {
    class SinglePostWindow;
}

class SinglePostWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit SinglePostWindow(QWidget *parent = 0, QString token = "0");
    ~SinglePostWindow();
    void loadPost(QString id);
    void setCountLabel(QString comments, QString likes);

private:
    Ui::SinglePostWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QPointer<QFacebookReply> reply;
    QPointer<QFacebookReply> commentReply;
    QPointer<QFacebookReply> likersReply;
    QString postId;
    QList<NewsFeedPost*> posts;
    QNetworkAccessManager *nam;
    bool gotMainPost;
    QString myId;

private slots:
    void onReplyReceived();
    void onCommentReplyReceived();
    void onPostButtonClicked();
    void orientationChanged();
    void onPostDestroyed(QObject*);
    void onNameClicked(QString,QString);
    void onLinkActivated(QString);
    void onGotLikers();
    void onLikerActivated(QListWidgetItem*);
};

#endif // SINGLEPOSTWINDOW_H
