#include "aboutdialog.h"
#include "ui_aboutdialog.h"

AboutDialog::AboutDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::AboutDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->pushButton, SIGNAL(clicked()), this, SLOT(donate()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
#ifdef Q_WS_MAEMO_5
    this->orientationChanged();
    ui->label_2->setPixmap(QIcon::fromTheme("general_facebook").pixmap(ui->label_2->size()));
    ui->label->setText(ui->label->text() + "\nFacebook for Nokia N900");
#endif
}

AboutDialog::~AboutDialog()
{
    delete ui;
}

void AboutDialog::donate()
{
    QDesktopServices::openUrl(QUrl("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RXNZ7B23RCV2Y"));
}

void AboutDialog::orientationChanged()
{
    if (QApplication::desktop()->screenGeometry().width() > QApplication::desktop()->screenGeometry().height())
        this->setMinimumHeight(400);
    else
        this->setMinimumHeight(430);
}
