#include "photoitem.h"
#include "ui_photoitem.h"

PhotoItem::PhotoItem(QWidget *parent, QString token, QNetworkAccessManager *nam) :
    QWidget(parent),
    ui(new Ui::PhotoItem),
    accessToken(token),
    nam(nam)
{
    ui->setupUi(this);
}

PhotoItem::~PhotoItem()
{
    delete ui;
}

void PhotoItem::setPixmap(QPixmap pixmap)
{
    ui->label->setPixmap(pixmap);
}

void PhotoItem::setPixmapFromUrl(QString url)
{
    photoReply = nam->get(QNetworkRequest(url));
    if (photoReply)
        connect(photoReply, SIGNAL(finished()), this, SLOT(onPhotoReplyReceived()));
}

void PhotoItem::onPhotoReplyReceived()
{
    QUrl redir = photoReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        photoReply->deleteLater();
        photoReply = nam->get(QNetworkRequest(redir));

        connect(photoReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    QPropertyAnimation *animation = new QPropertyAnimation(ui->label, "pos", this);
    animation->setStartValue(QPoint(ui->label->x(), ui->label->y()-200));
    animation->setEndValue(ui->label->pos());
    animation->setDuration(1000);
    animation->setEasingCurve(QEasingCurve::InOutBack);
    animation->start(QPropertyAnimation::DeleteWhenStopped);
    ui->label->setPixmap(QPixmap::fromImage(QImage::fromData(photoReply->readAll())));
    photoReply->deleteLater();
}

void PhotoItem::setSourcePhotoLink(QString url)
{
    m_sourceUrl = url;
}

void PhotoItem::setLargePhotoLink(QString url)
{
    m_largeUrl = url;
}

void PhotoItem::setNormalPhotoLink(QString url)
{
    m_normalUrl = url;
}

void PhotoItem::setSmallPhotoLink(QString url)
{
    m_smallUrl = url;
}

void PhotoItem::setPhotoId(QString id)
{
    m_photoId = id;
}

void PhotoItem::setUserId(QString userId)
{
    m_userId = userId;
}

void PhotoItem::setTags(QVariantList tags)
{
    m_tags = tags;
}

void PhotoItem::setComments(QVariantList comments)
{
    m_comments = comments;
}

QVariantList PhotoItem::comments()
{
    return m_comments;
}

QVariantList PhotoItem::tags()
{
    return m_tags;
}

QString PhotoItem::userId()
{
    return m_userId;
}

QString PhotoItem::photoId()
{
    return m_photoId;
}

QString PhotoItem::largeUrl()
{
    return m_largeUrl;
}

QString PhotoItem::normalUrl()
{
    return m_normalUrl;
}

QString PhotoItem::smallUrl()
{
    return m_smallUrl;
}

QString PhotoItem::sourceUrl()
{
    return m_sourceUrl;
}

void PhotoItem::mousePressEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = true;
        emit pressed();
    }
}

void PhotoItem::mouseReleaseEvent(QMouseEvent *ev)
{
    if (ev->button() == Qt::LeftButton) {
        m_pressed = false;
        emit released();
        if (rect().contains(ev->pos())) {
            emit clicked(this);
        }
    }
}
