#include "chatmessageitem.h"
#include "ui_chatmessageitem.h"

ChatMessageItem::ChatMessageItem(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::ChatMessageItem)
{
    ui->setupUi(this);
    QPalette p = this->palette();
    p.setColor(QPalette::Foreground, p.highlight().color());
    ui->nameLabel->setPalette(p);
    ui->timeLabel->setText(QTime::currentTime().toString("hh:mm"));
}

ChatMessageItem::~ChatMessageItem()
{
    delete ui;
}

void ChatMessageItem::setName(QString name)
{
    ui->nameLabel->setText(name);
}

void ChatMessageItem::setMessage(QString message)
{
    ui->messageLabel->setText(message);
}

void ChatMessageItem::setTime(QString time)
{
    ui->timeLabel->setText(time);
}

void ChatMessageItem::setAvatar(QPixmap avatar)
{
    if (avatar.isNull()) {
        ui->avatarLabel->hide();
        return;
    }
    ui->avatarLabel->setPixmap(avatar);
    if (ui->avatarLabel->isHidden())
        ui->avatarLabel->show();
}
