#include "singlepostwindow.h"
#include "ui_singlepostwindow.h"
#include "profilewindow.h"

SinglePostWindow::SinglePostWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::SinglePostWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this)),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    connect(ui->commentButton, SIGNAL(clicked()), this, SLOT(onPostButtonClicked()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    connect(ui->count, SIGNAL(linkActivated(QString)), this, SLOT(onLinkActivated(QString)));
    this->orientationChanged();
    gotMainPost = false;
    myId = QSettings().value("main/myId").toString();
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        QPalette p(palette());
        p.setColor(QPalette::Background, QColor(220, 225, 235));
        setPalette(p);
    }
}

SinglePostWindow::~SinglePostWindow()
{
    delete ui;
}

void SinglePostWindow::loadPost(QString id)
{
    this->postId = id;
    this->reply = qfacebook->getObject(id);
    connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void SinglePostWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-15);
}

void SinglePostWindow::setCountLabel(QString comments, QString likes)
{
    if (comments.toInt() == 0 && likes.toInt() == 0) {
        ui->count->clear();
        ui->count->hide();
        return;
    }

    QString text;
    text.append(comments + " ");

    if (comments.toInt() == 1)
        text.append(tr("comment"));
    else
        text.append(tr("comments"));

    if (likes.toInt() == 0) {
        ui->count->setText(text);
        return;
    }
    //<a href=\"%1\">%2</a>
    text.append(" " + tr("and") + " " + QString("<a href=\"%1\">").arg(QString("likes://" + postId)) + likes + " ");
    if (likes.toInt() == 1)
        text.append(tr("like"));
    else
        text.append(tr("likes"));
    text.append("</a>");
    ui->count->setText(text);
}

void SinglePostWindow::onLinkActivated(QString url)
{
    if (url.contains("likes://")) {
        ui->count->blockSignals(true);
        QString id = url.remove("likes://");
        likersReply = qfacebook->getConnections(id, "likes");
        if (likersReply)
            connect(likersReply, SIGNAL(finished()), this, SLOT(onGotLikers()));
    }
}

void SinglePostWindow::onGotLikers()
{
    ui->count->blockSignals(false);
    QVariant likersData = likersReply->data();
    QDialog *likersDialog = new QDialog(this);
#ifdef Q_WS_MAEMO_5
    likersDialog->setMinimumHeight(800);
#endif
    likersDialog->setWindowTitle(tr("People who like this"));
    QVBoxLayout *layout = new QVBoxLayout(likersDialog);
    QListWidget *listWidget = new QListWidget(likersDialog);
    connect(listWidget, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onLikerActivated(QListWidgetItem*)));
    layout->addWidget(listWidget);
    QVariantList likersList = likersData.toMap().value("data").toList();
    foreach (QVariant liker, likersList) {
        QListWidgetItem *item = new QListWidgetItem(listWidget);
        item->setData(Qt::UserRole, liker.toMap().value("id").toString());
        item->setText(liker.toMap().value("name").toString());
    }
#ifdef Q_WS_60
    likersDialog->showMaximized();
#else
    likersDialog->show();
#endif
}

void SinglePostWindow::onLikerActivated(QListWidgetItem *item)
{
    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->setWindowTitle(item->text());
    profile->browseProfile(item->data(Qt::UserRole).toString());
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}

void SinglePostWindow::onReplyReceived()
{
    if (!posts.isEmpty()) {
        foreach (NewsFeedPost *post, posts) {
            ui->commentsLayout->addWidget(post);
            delete post;
        }
        posts.clear();
    }

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch comments!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    bool deletable = false;
    QVariant jsonData = this->reply->data();
    QString name = jsonData.toMap().value("from").toMap().value("name").toString();
    QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
    if (userId == myId)
        deletable = true;
    QVariantList toIds = jsonData.toMap().value("to").toMap().value("data").toList();
    foreach (QVariant toId, toIds) {
        if (toId.toMap().value("id").toString() == myId)
            deletable = true;
    }

    QString message = jsonData.toMap().value("message").toString();
    QString time = jsonData.toMap().value("created_time").toString();
    QString linkName;
    QString linkDescription;
    QString linkPicture;
    QString link = jsonData.toMap().value("link").toString();
    QString sourceLink = jsonData.toMap().value("source").toString();
    QString postType = jsonData.toMap().value("type").toString();
    if (link.isEmpty() || (postType == "video" && sourceLink.contains("fbcdn")))
        link = sourceLink;
    QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
    if (likesCount.isEmpty())
        likesCount = "0";
    if (link.isEmpty())
        link = jsonData.toMap().value("source").toString();
    QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
    QString myId = QSettings().value("main/myId").toString();
    bool meLikesThis = false;
    foreach (QVariant likeId, likes) {
        QVariantMap map = likeId.value<QVariantMap>();
        QString likerId = map.value("id").toString();
        if (likerId.contains(myId)) {
            meLikesThis = true;
            break;
        }
    }
    QString toId;
    QString toName;
    QVariantList toVariant = jsonData.toMap().value("to").toMap().value("data").toList();
    if (!toVariant.isEmpty()) {
        QVariant to = toVariant.last();

        foreach (QVariant taggedName, toVariant) {
            QString name = taggedName.toMap().value("name").toString();
            QString id = taggedName.toMap().value("id").toString();
            if (message.contains(name)) {
                message = message.replace(name, QString("<a href=\"profile://%1\">%2</a>").arg(id, name));
            }
        }

        toId = to.toMap().value("id").toString();
        toName = to.toMap().value("name").toString();
    }

    if (!gotMainPost) {
        NewsFeedPost *post = new NewsFeedPost(this, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(destroyed()), this, SLOT(close()));
        if (!link.isEmpty()) {
            post->addLink(link,
                          jsonData.toMap().value("name").toString(),
                          jsonData.toMap().value("description").toString(),
                          jsonData.toMap().value("picture").toString());
        }
        post->setCommentMode(true);
        post->setType(postType);
        post->setLikedByMe(meLikesThis);
        post->setDeletable(deletable);
        post->setMessage(message);
        post->setName(name);
        post->setUserId(userId);
        if (!toName.isEmpty() && !toId.isEmpty())
            post->setToName(toName, toId);
        if (!link.isEmpty())
            post->addLink(link, linkName, linkDescription, linkPicture);
        post->setNumberOfLikesComments(likesCount, "0");
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setId(this->postId);
        post->setTime(time);
        ui->mainPostLayout->addWidget(post);
        gotMainPost = true;
    }

    QVariantList listData;
    listData = jsonData.toMap().value("comments").toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->commentsWidget, accessToken, qfacebook, nam);
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(destroyed(QObject*)), this, SLOT(onPostDestroyed(QObject*)));
        post->setCommentMode(true);
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        if (userId == myId || deletable)
            post->setDeletable(true);
        QString message = jsonData.toMap().value("message").toString();
        QString icon = jsonData.toMap().value("icon").toString();
        QString time = jsonData.toMap().value("created_time").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (link.isEmpty())
            link = jsonData.toMap().value("source").toString();
        if (!link.isEmpty()) {
            post->addLink(link,
                          jsonData.toMap().value("name").toString(),
                          jsonData.toMap().value("description").toString(),
                          jsonData.toMap().value("picture").toString());
        }

        QVariantList toVariant = jsonData.toMap().value("to").toMap().value("data").toList();
        if (!toVariant.isEmpty()) {
            QVariant to = toVariant.first();
            if (message.contains(to.toMap().value("name").toString()) && toVariant.count() > 1)
                to = toVariant.at(1);

            foreach (QVariant taggedName, toVariant) {
                QString name = taggedName.toMap().value("name").toString();
                QString id = taggedName.toMap().value("id").toString();
                if (message.contains(name)) {
                    message.replace(name, QString("<a href=\"profile://%1\">%2</a>").arg(id, name));
                }
            }
            post->setMessage(message);
        }

        // Check if the currently logged in user likes the post
        QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
        bool meLikesThis = false;
        foreach (QVariant likeId, likes) {
            QVariantMap map = likeId.value<QVariantMap>();
            QString likerId = map.value("id").toString();
            if (likerId.contains(myId)) {
                meLikesThis = true;
                break;
            }
        }

        // Get like and comment count.
        QString likesCount = jsonData.toMap().value("likes").toString();
        if (likesCount.isEmpty())
            likesCount = "0";

        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setLikedByMe(meLikesThis);
        post->setNumberOfLikesComments(likesCount, "0");
        post->setIconFromUrl(icon);
        post->setTime(time);
        posts.append(post);
        ui->commentsLayout->addWidget(post);
    }
}

void SinglePostWindow::onPostDestroyed(QObject *object)
{
    posts.removeOne((NewsFeedPost*)object);
}

void SinglePostWindow::onNameClicked(QString id, QString name)
{
    ProfileWindow *window = new ProfileWindow(this, accessToken);
    window->setWindowTitle(name);
    window->browseProfile(id);
#ifdef Q_WS_S60
    window->showMaximized();
#else
    window->show();
#endif
}

void SinglePostWindow::onPostButtonClicked()
{
    if (ui->replyEdit->text().isEmpty()) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Unable to post empty comment!"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Unable to post empty comment!"));
#endif
        return;
    }

    QByteArray data;
    data.append("message=" + ui->replyEdit->text().toUtf8());
    this->commentReply = qfacebook->putObject(this->postId, "comments", data);
    if (this->commentReply)
        connect(commentReply, SIGNAL(finished()), this, SLOT(onCommentReplyReceived()));
    ui->replyEdit->setEnabled(false);
    ui->commentButton->setEnabled(false);
}

void SinglePostWindow::onCommentReplyReceived()
{
    ui->replyEdit->setEnabled(true);
    ui->commentButton->setEnabled(true);

    if (this->commentReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to post comment!";
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Failed to post comment!"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Failed to post comment!"));
#endif
        this->commentReply->deleteLater();
        this->commentReply = 0;

        return;
    }

    ui->replyEdit->clear();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Comment posted"));
#endif

    this->commentReply->deleteLater();

    this->loadPost(this->postId);
}
