#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <QDialog>
#include <QResizeEvent>
#include "widgets/progressitem.h"

namespace Ui {
    class ProgressDialog;
}

class ProgressDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ProgressDialog(QWidget *parent = 0);
    ~ProgressDialog();

protected:
    void resizeEvent(QResizeEvent *);

public slots:
    void showProgress(QString name, int percentage);

private:
    Ui::ProgressDialog *ui;
    QList<ProgressItem*> progressItems;
    QStringList uploadNames;
    QMap<QString, ProgressItem*> progressMap;
};

#endif // PROGRESSDIALOG_H
