#include "notewindow.h"
#include "ui_notewindow.h"

NoteWindow::NoteWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::NoteWindow),
    accessToken(token),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    isCreateMode = false;
    isEditMode = false;
    connect(ui->actionEdit, SIGNAL(triggered()), this, SLOT(onEditTriggered()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    new TextEditAutoResizer(ui->textEdit);
#endif
}

NoteWindow::~NoteWindow()
{
    delete ui;
}

QTextEdit* NoteWindow::textEdit()
{
    return ui->textEdit;
}

void NoteWindow::showNote(QString noteId)
{
    m_noteId = noteId;
    reply = qfacebook->getObject(noteId);
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void NoteWindow::onReplyReceived()
{
    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch notes!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    QVariant jsonData = reply->data();
    ui->textEdit->setText(jsonData.toMap().value("message").toString());
    this->setWindowTitle(jsonData.toMap().value("subject").toString());
}

void NoteWindow::setCreateMode(QString subject, QString id)
{
    isCreateMode = true;
    ui->textEdit->setReadOnly(false);
    ui->menubar->removeAction(ui->actionEdit);
    m_subjectText = subject;
    m_toWallId = id;
}

void NoteWindow::onEditTriggered()
{
    isEditMode = true;
    ui->textEdit->setReadOnly(false);
}

void NoteWindow::closeEvent(QCloseEvent *e)
{
    if (isCreateMode) {
        QMessageBox shouldPost(QMessageBox::NoIcon,
                               " ",
                               tr("This post has not been posted, do you want to post it?"),
                               QMessageBox::Yes | QMessageBox::No);
        shouldPost.exec();
        if (shouldPost.result() == QMessageBox::Yes) {
            QByteArray data;
            data.append("subject=");
            data.append(m_subjectText);
            data.append("&message=");
            data.append(ui->textEdit->toPlainText().toUtf8());
            e->ignore();
            QFacebookReply *reply = qfacebook->putObject(m_toWallId, "notes", data);
            qDebug() << m_toWallId;
            connect(reply, SIGNAL(finished()), this, SLOT(onNotePosted()));
        }
    } else if (isEditMode) {
        QMessageBox shouldPost(QMessageBox::NoIcon,
                               " ",
                               tr("This post has not been saved, do you want to save it?"),
                               QMessageBox::Yes | QMessageBox::No);
        shouldPost.exec();
        if (shouldPost.result() == QMessageBox::Yes) {
            QByteArray data;
            data.append("message=");
            data.append(ui->textEdit->toPlainText().toUtf8());
            e->ignore();
            QFacebookReply *reply = qfacebook->putObject(m_noteId, "", data);
            connect(reply, SIGNAL(finished()), this, SLOT(onNotePosted()));
        }
    }
}

void NoteWindow::onNotePosted()
{
    isCreateMode = false;
    isEditMode = false;
    this->close();
}
