#ifndef LOGINWINDOW_H
#define LOGINWINDOW_H

#include <QMainWindow>
#include <QCloseEvent>
#include <QTimer>
#include <QUrl>
#include <QString>
#include <QDebug>
#include <QDesktopServices>
#include <QDir>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include "qwebviewselectionsuppressor.h"
#endif

#include "cookiejar.h"

#ifdef Q_WS_MAEMO_5
#define appId "198401840201289"
#elif Q_WS_MAEMO_6
#define appId "155528487852398"
#else
#define appId "133764606703287"
#endif

/* TODO: Add Android define */
#if defined (Q_WS_MAEMO_5) || defined (Q_WA_S60)
    #define authUrl "https://www.facebook.com/dialog/oauth?client_id=%2&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=%1&response_type=token"
#else
    #define authUrl "https://www.facebook.com/dialog/oauth?client_id=%2&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=%1&response_type=token"
#endif

namespace Ui {
    class LoginWindow;
}

class LoginWindow : public QMainWindow
{
    Q_OBJECT

protected:
    void closeEvent(QCloseEvent *);

public:
    explicit LoginWindow(QWidget *parent = 0);
    ~LoginWindow();

signals:
    void loggedIn(QString accessToken);

private:
    Ui::LoginWindow *ui;
    bool disableCloseButton;
    bool isLoggingIn;
    QStringList permissionsList();

private slots:
    void onUrlChanged(QUrl url);
    void onLoggedIn();
    void onLoadStarted();
    void onInitalLoadFinished(bool);
    void onLoadFinished(bool);
};

#endif // LOGINWINDOW_H
