#include "systemnotification.h"
#include "mainwindow.h"

SystemNotification::SystemNotification(QObject *parent) :
    QObject(parent),
    m_player(new QMediaPlayer(this))
{
    connect(m_player, SIGNAL(error(QMediaPlayer::Error)), this, SLOT(onErrorOccured(QMediaPlayer::Error)));
#ifdef Q_WS_MAEMO_5
    m_interface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF,
                                   QDBusConnection::systemBus(), this);
#endif
}

void SystemNotification::onErrorOccured(QMediaPlayer::Error)
{
    qDebug() << m_player->errorString();
}

void SystemNotification::createNotification(QString name, QString message, QString icon)
{
    if (!QSettings().value("main/gui-notifications").toBool())
        return;

#ifdef Q_WS_MAEMO_5
    QeMaemo5Notification *notification = new QeMaemo5Notification(message, this, name);
    if (this->parent() != 0) {
        connect(notification, SIGNAL(clicked()), (QWidget*)this->parent(), SLOT(show()));
        if (this->parent()->parent() != 0)
            connect(notification, SIGNAL(clicked()), (MainWindow*)this->parent()->parent(), SLOT(top_application()));
    }
    notification->setIcon(icon);
    notification->setCategory("sociality-new-notifications");
    notification->show();
    m_notifications.append(notification);
    m_interface->call(MCE_ACTIVATE_LED_PATTERN, "PatternCommonNotification");
#else
    Q_UNUSED(name)
    Q_UNUSED(message)
    Q_UNUSED(icon)
#endif

}

void SystemNotification::vibrate(SystemNotification::PostTypes postType)
{
    switch (postType) {
    case SystemNotification::Notification:
        qint32 duration = QSettings().value("vibration/notification-duration", 200).toInt();
#ifndef Q_WS_MAEMO_5
        QFeedbackHapticsEffect rumble;
        rumble.setIntensity(1.0);
        rumble.setDuration(duration);
        rumble.start();
#else
        qint32 speed = QSettings().value("vibration/notification-speed", 150).toInt();

        if (speed == 0 || duration == 0)
            return;

        m_interface->call(MCE_START_MANUAL_VIBRATION, speed, duration);
#endif
        break;
    }
}

void SystemNotification::clearNotifications()
{
#ifdef Q_WS_MAEMO_5
    m_interface->call(MCE_DEACTIVATE_LED_PATTERN, "PatternCommonNotification");
    foreach (QObject *notification, m_notifications) {
        qobject_cast<QeMaemo5Notification*>(notification)->hide();
        notification->deleteLater();
    }
#endif
    m_notifications.clear();
}

void SystemNotification::createSoundNotification(int volume)
{
#ifdef Q_WS_MAEMO_5
    if (QString::fromUtf8(profile_get_profile()) == "silent")
        return;
#endif

    if (m_player->state() != QMediaPlayer::PlayingState) {
        m_player->setVolume(volume);
#ifdef Q_WS_MAEMO_5
        m_player->setMedia(QMediaContent(QUrl::fromLocalFile(QSettings().value("main/notifications-soundfile",
                                                                               "/opt/usr/share/sociality/notification.wav").toString())));
#else
        m_player->setMedia(QMediaContent(QUrl::fromLocalFile(QSettings().value("main/notifications-soundfile").toString())));
#endif
        m_player->play();
    }
}
