#ifndef NEWSFEEDWINDOW_H
#define NEWSFEEDWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QDesktopWidget>
#include <QNetworkAccessManager>
#include <QSettings>
#include <QScrollBar>
#include <QPointer>
#include <QThread>
#ifndef Q_WS_MAEMO_5
    #include <QMessageBox>
#endif
#include "newstatusupdatedialog.h"
#include "singlepostwindow.h"
#include "newsfeedpost.h"
#include "profilewindow.h"
#include "qfacebook.h"
#include "widgets/loadingwidget.h"

namespace Ui {
    class NewsFeedWindow;
}

class NewsFeedWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit NewsFeedWindow(QWidget *parent = 0, QString token = "0");
    ~NewsFeedWindow();

protected:
    void keyPressEvent(QKeyEvent *);

private:
    Ui::NewsFeedWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QPointer<QFacebookReply> reply;
    QPointer<QFacebookReply> statusReply;
    QNetworkAccessManager *nam;
    QList<NewsFeedPost*> posts;
    QString myId;
    QString myName;
    QVariant m_postsVariant;
    QPointer<LoadingWidget> m_loadingWidget;
    QPointer<NewStatusUpdateDialog> m_statusUpdateDialog;

private slots:
    void onNewStatusUpdateButtonClicked();
    void postUpdate(QString, QString, QString);
    void updateNewsFeed();
    void onReplyFinished();
    void orientationChanged();
    void onCommentButtonClicked(QString, QString, QString);
    void onNameClicked(QString, QString);
    void onStatusUpdateReplyFinished();
    void onParserThreadFinished();
    void onNewsFeedItemParsed(QString fromName, QString fromId, bool isDeletable, QString message, QString icon, QString time,
                              QString link, QString linkName, QString linkDescription, QString linkPicture, QString toId, QString toName,
                              bool meLikesThis, QString commentsCount, QString likesCount, QString postId, QString postType, QString objectId);
};

class NewsFeedParser : public QObject
{
    Q_OBJECT

public:
    explicit NewsFeedParser(QVariant jsonData, QString accessToken);

public slots:
    void start();

signals:
    void feedItemParsed(QString fromName, QString fromId, bool isDeletable, QString message, QString icon, QString time,
                        QString link, QString linkName, QString linkDescription, QString linkPicture, QString toId, QString toName,
                        bool meLikesThis, QString commentsCount, QString likesCount, QString postId, QString postType, QString objectId);
    void finished();

private:
    QVariant m_jsonData;
    QString accessToken;
    QFacebook *qfacebook;
    QNetworkAccessManager *nam;

private slots:
};

#endif // NEWSFEEDWINDOW_H
