#ifndef GROUPSWINDOW_H
#define GROUPSWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QListWidgetItem>
#include "profilewindow.h"
#include <qfacebook.h>

namespace Ui {
    class GroupsWindow;
}

class GroupsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit GroupsWindow(QWidget *parent = 0, QString token = "0");
    ~GroupsWindow();
    void browseGroups(QString userId);

private:
    Ui::GroupsWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QNetworkAccessManager *nam;
    QString m_userId;

private slots:
    void updateGroups();
    void onReplyReceived();
    void onAvatarProcessed(QString id, QPixmap pixmap);
    void onGroupClicked(QListWidgetItem *item);
};

class Group : public QObject
{
    Q_OBJECT

public:
    explicit Group(QWidget *parent = 0, QString id = "0");
    ~Group();

signals:
    void avatarProcessed(QString, QPixmap);

public slots:
    void avatarReceived();

private:
    QString groupId;
};

#endif // GROUPSWINDOW_H
