#ifndef CHATCONVERSATIONWINDOW_H
#define CHATCONVERSATIONWINDOW_H

#include <QMainWindow>
#include <QScrollBar>
#include <QPointer>
#include "widgets/chatmessageitem.h"
#include <qxmpp/QXmppClient.h>

namespace Ui {
    class ChatConversationWindow;
}

class ChatConversationWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ChatConversationWindow(QWidget *parent = 0);
    ~ChatConversationWindow();
    QString getDisplayName() const;
    QString getBareJid() const;
    void setQXmppClient(QXmppClient* client);

protected:
    void resizeEvent(QResizeEvent *);

public slots:
    void setBareJid(const QString &bareJid);
    void setDisplayName(const QString &name);
    void messageReceived(const QString &message);

private:
    Ui::ChatConversationWindow *ui;
    QString m_bareJid;
    QString m_displayName;
    QPointer<QXmppClient> m_qxmppClient;
    QList<ChatMessageItem*> messagesList;
    void addMessage(QString name, QString message, QPixmap avatar = QPixmap());

private slots:
    void sendMessage();

};

#endif // CHATCONVERSATIONWINDOW_H
