#ifndef PHOTOITEM_H
#define PHOTOITEM_H

#include <QWidget>
#include <QPropertyAnimation>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QMouseEvent>
#include <QDebug>

namespace Ui {
    class PhotoItem;
}

class PhotoItem : public QWidget
{
    Q_OBJECT

public:
    explicit PhotoItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~PhotoItem();
    void setPixmap(QPixmap pixmap);
    void setPixmapFromUrl(QString url);
    void setPhotoId(QString photoId);
    void setUserId(QString userId);
    void setLargePhotoLink(QString url);
    void setNormalPhotoLink(QString url);
    void setSmallPhotoLink(QString url);
    void setSourcePhotoLink(QString url);
    void setComments(QVariantList comments);
    void setTags(QVariantList tags);
    QString largeUrl();
    QString normalUrl();
    QString smallUrl();
    QString photoId();
    QString userId();
    QString sourceUrl();
    QVariantList tags();
    QVariantList comments();

protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

signals:
    void pressed();
    void released();
    void clicked(PhotoItem*);

private:
    Ui::PhotoItem *ui;
    QString accessToken;
    QNetworkAccessManager *nam;
    QNetworkReply *photoReply;
    QString m_photoId;
    QString m_userId;
    QString m_largeUrl;
    QString m_normalUrl;
    QString m_smallUrl;
    QString m_sourceUrl;
    bool m_pressed;
    QVariantList m_comments;
    QVariantList m_tags;

private slots:
    void onPhotoReplyReceived();
};

#endif // PHOTOITEM_H
