#ifndef EVENTITEM_H
#define EVENTITEM_H

#include <QWidget>
#include <qfacebook.h>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QMap>
#include <QDebug>
#include <QDateTime>
#include <QDesktopWidget>
#include <QListWidget>
#include <QListWidgetItem>
#include <QDialog>

namespace Ui {
    class EventItem;
}

class EventItem : public QWidget
{
    Q_OBJECT

public:
    explicit EventItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~EventItem();
    void setTime(QString time);
    void setName(QString name);
    void setLocation(QString location);
    void setEventId(QString id);
    void setAvatarUrl(QString url);
    void setUserId(QString id);
    void setRsvp(QString rsvp);

private:
    Ui::EventItem *ui;
    QString m_eventId;
    QNetworkAccessManager *nam;
    QString accessToken;
    QNetworkReply *avatarReply;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *rsvpReply;
    QFacebookReply *attendingReply;
    QMap<QString,QString> attending;
    QMap<QString,QString> maybeAttending;
    QMap<QString,QString> notAttending;
    QMap<QString,QString> awaitingReply;
    QString m_userId;
    void appendAttendee(QString name, QString userId);

private slots:
    void onAvatarReceived();
    void onReplyReceived();
    void updateAttendees();
    void onRsvpChanged(int);
    void onRsvpReplyReceived();
    void orientationChanged();
    void onAttendeesButtonClicked();
    void onAttendeesReplyReceived();
    void onAttendeeClicked(QListWidgetItem *item);
};

#endif // EVENTITEM_H
