#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QSettings>
#include <QListWidgetItem>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QMetaType>
#include <QMenu>
#include "loginwindow.h"
#include "friendswindow.h"
#include "newsfeedwindow.h"
#include "messageswindow.h"
#include "albumswindow.h"
#include "notificationsdialog.h"
#include "groupswindow.h"
#include "eventswindow.h"
#include "placeswindow.h"
#include "noteswindow.h"
#include "aboutdialog.h"
#include "chatwindow.h"
#include "settingsdialog.h"
#include "facebookbrowser.h"

#include "delegates/thumbnailitemdelegate.h"

namespace Ui {
    class MainWindow;
}

typedef struct
{
    QString text;
    QIcon avatar;
    QString userId;
} FavoriteItem;

QDataStream &operator<<(const QDataStream &out, const FavoriteItem &item);
QDataStream &operator>>(const QDataStream &in, FavoriteItem &item);
bool operator==(const FavoriteItem &item1, const FavoriteItem &item2);

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    Q_SCRIPTABLE void top_application();

signals:
    void refresh();

private:
    Ui::MainWindow *ui;
    void connectSignals();
    QString accessToken;
    QString myId;
    QString myName;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    NewsFeedWindow *newsFeedWindow;
    FriendsWindow *friendsWindow;
    AlbumsWindow *albumsWindow;
    ProfileWindow *profileWindow;
    GroupsWindow *groupsWindow;
    LoginWindow *loginWindow;
    EventsWindow *eventsWindow;
    ChatWindow *chatWindow;
    NotesWindow *notesWindow;
    NotificationsDialog *notificationsDialog;
    QNetworkAccessManager *nam;
    QNetworkReply *requestsReply;
    QTimer *m_refreshTimer;
    QList<FavoriteItem>favorites;
    void getMyId();
    int defaultItemCount;

private slots:
    void createLoginWindow();
    void logout();
    void deleteWindows();
    void onLoggedIn(QString token);
    void onItemActivated(QListWidgetItem *item);
    void orientationChanged();
    void onGetMyIdReply();
    void onContextMenuRequested(QPoint point);
    void onFavoriteDeleteRequested();
    void onGotNotificationCount(int count);
    void getRequestsCount();
    void onGotRequestCount();
    void showAbout();
    void onAddToFavoritesClicked();
    void onFriendSelected(QList<QListWidgetItem*>);
    void saveFavorites();
    void loadFavorites();
    void onRefreshTimeout();
    void onAvatarProcessed(QString id, QImage image);
    void showSettings();
    void openAccountSettings();
    void openPrivacySettings();
    void openHelpCenter();
    void onChatLoginCanceled();

#ifdef Q_WS_MAEMO_5
    void takeScreenshot();
#endif
};

#endif // MAINWINDOW_H
