#ifndef LOGINWINDOW_H
#define LOGINWINDOW_H

#include <QMainWindow>
#include <QCloseEvent>
#include <QTimer>
#include <QUrl>
#include <QString>
#include <QDebug>
#include <QDesktopServices>
#include <QDir>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include "qwebviewselectionsuppressor.h"
#endif

#include "cookiejar.h"

/* TODO: Add Android define */
#define perms "user_notes,friends_notes,publish_checkins,user_checkins,friends_checkins,create_event,user_events,rsvp_event,friends_events,user_groups,friends_groups,manage_pages,user_photos,friends_photos,read_stream,offline_access,publish_stream,read_mailbox,friends_birthday,friends_relationships,user_relationships,user_relationship_details,friends_relationship_details,user_location,friends_location,user_hometown,friends_hometown,user_activities,friends_activities,friends_status"
#if defined (Q_WS_MAEMO_5) || defined (Q_WA_S60)
    #define authUrl "https://www.facebook.com/dialog/oauth?client_id=198401840201289&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=%1&response_type=token&display=touch"
#else
    #define authUrl "https://www.facebook.com/dialog/oauth?client_id=198401840201289&redirect_uri=https://www.facebook.com/connect/login_success.html&scope=%1&response_type=token"
#endif

namespace Ui {
    class LoginWindow;
}

class LoginWindow : public QMainWindow
{
    Q_OBJECT

protected:
    void closeEvent(QCloseEvent *);

public:
    explicit LoginWindow(QWidget *parent = 0);
    ~LoginWindow();

signals:
    void loggedIn(QString accessToken);

private:
    Ui::LoginWindow *ui;
    bool disableCloseButton;
    bool isLoggingIn;

private slots:
    void onUrlChanged(QUrl url);
    void onLoggedIn();
    void onLoadStarted();
    void onInitalLoadFinished(bool);
};

#endif // LOGINWINDOW_H
