#ifndef IMAGEUPLOADDIALOG_H
#define IMAGEUPLOADDIALOG_H

#include <QDialog>
#include <QPushButton>
#include <QFileDialog>
#include <QListWidgetItem>
#include <photowindow.h>

namespace Ui {
    class ImageUploadDialog;
}

class ImageUploadDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ImageUploadDialog(QWidget *parent = 0);
    ~ImageUploadDialog();

signals:
    void addImage(QString imageUrl);

private:
    Ui::ImageUploadDialog *ui;

private slots:
    void onPhotoClicked(QListWidgetItem*);
    void onLocalFileButtonClicked();
    void onCameraButtonClicked();
    void onImageReceived(QString filename);
};

#endif // IMAGEUPLOADDIALOG_H
