#include "checkindialog.h"
#include "ui_checkindialog.h"

CheckinDialog::CheckinDialog(QWidget *parent, QString token) :
    QDialog(parent),
    ui(new Ui::CheckinDialog),
    accessToken(token),
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    this->orientationChanged();
}

CheckinDialog::~CheckinDialog()
{
    delete ui;
}

void CheckinDialog::setCoordinates(double longitude, double latitude)
{
    m_longitude = longitude;
    m_latitude = latitude;
    m_locationString = QString::number(latitude) + "," + QString::number(longitude);
    this->refreshPlaces();
}

void CheckinDialog::refreshPlaces()
{
    reply = qfacebook->getObject(QString("search&type=place&center=%1&distance=1000").arg(m_locationString));
    if (reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void CheckinDialog::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch places!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    QVariant locations = reply->data();

    if (locations == m_locations)
        return;
    else
        m_locations = locations;

    ui->listWidget->clear();

    QVariant jsonData = locations;
    QVariantList listData = jsonData.toMap().value("data").toList();
    foreach (jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem(ui->listWidget);
        QString id = jsonData.toMap().value("id").toString();
        QString name = jsonData.toMap().value("name").toString();
        QVariant latitude = jsonData.toMap().value("location").toMap().value("latitude");
        QVariant longitude = jsonData.toMap().value("location").toMap().value("longitude");
        item->setData(LocationId, id);
        item->setData(Latitude, latitude);
        item->setData(Longitude, longitude);
        item->setText(name);
    }
}

void CheckinDialog::accept()
{
    if (ui->listWidget->selectedItems().count() == 0)
        return;

    QListWidgetItem *selectedItem = ui->listWidget->selectedItems().first();
    emit placeSelected(selectedItem->text(),
                       selectedItem->data(LocationId).toString(),
                       selectedItem->data(Longitude).toString(),
                       selectedItem->data(Latitude).toString());
    this->close();
}

void CheckinDialog::orientationChanged()
{
    ui->gridLayout->removeWidget(ui->buttonBox);
    if (QApplication::desktop()->screenGeometry().width() > QApplication::desktop()->screenGeometry().height()) {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Minimum));
        ui->gridLayout->addWidget(ui->buttonBox, 0, 1, 1, 1);
        this->setMinimumHeight(365);
    } else {
        ui->buttonBox->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum));
        ui->gridLayout->addWidget(ui->buttonBox, 1, 0, 1, ui->gridLayout->columnCount(), Qt::AlignBottom);
        this->setMinimumHeight(800);
    }
}
