#ifndef YOUTUBEPLAYER_H
#define YOUTUBEPLAYER_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkCookie>
#include <QNetworkCookieJar>
#include <QDebug>
#include <QMediaPlayer>
#include <QMediaObject>
#include <QResizeEvent>
#include <QTimer>
#include <QTime>
#include <QKeyEvent>
#include <QClipboard>
#include <QDesktopServices>

#include "widgets/videowidget.h"

//QTM_USE_NAMESPACE

namespace Ui {
    class YoutubePlayer;
}

class YoutubePlayer : public QMainWindow
{
    Q_OBJECT

public:
    explicit YoutubePlayer(QWidget *parent = 0);
    ~YoutubePlayer();
    void getVideoUrl(const QString &playerUrl);
    void setOriginalUrl(QString url);

protected:
    void keyPressEvent(QKeyEvent *);
    void keyReleaseEvent(QKeyEvent *);

public slots:
    void showExpanded();

signals:
    void videoUrlError();
    void alert(QString error);
    void gotVideoUrl(QString url);

private:
    Ui::YoutubePlayer *ui;
    VideoWidget *m_videoWidget;
    QMediaPlayer *m_player;
    QList<QNetworkCookie> m_cookiesList;
    QVariant m_cookieVariant;
    QString m_originalUrl;
    QTimer *volumeTimer;
    int m_duration;
    int m_position;

private slots:
    void parseVideoPage(QNetworkReply *reply);
    void onGotVideoUrl(QString);
    //void stateChanged(Phonon::State newState, Phonon::State oldState);
    void onErrorOccured(QMediaPlayer::Error error);
    void onVideoWidgetDoubleClicked();
    void onPositionChanged(qint64 position);
    void onDurationChanged(qint64 duration);
    void toggleVolumeSlider();
    void volumeWatcher();
    void onFullScreenChanged(bool);
    void onPositionSliderMoved(int);
    void openInBrowser();
    void copyUrl();
    void onStateChanged(QMediaPlayer::State);
    void playPause();
};

#endif // YOUTUBEPLAYER_H
