#include "profilewindow.h"
#include "ui_profilewindow.h"
#include "albumswindow.h"

ProfileWindow::ProfileWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::ProfileWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    //connect(ui->writeOnWallEdit, SIGNAL(), this, SLOT(onTextBoxClicked()));
    connect(ui->writeOnWallEdit, SIGNAL(clicked()), this, SLOT(onTextBoxClicked()));
    connect(ui->actionRefresh, SIGNAL(triggered()), this, SLOT(updateProfile()));
    connect(ui->userAvatar, SIGNAL(clicked()), this, SLOT(onAvatarClicked()));
    connect(ui->actionPhotos, SIGNAL(triggered()), this, SLOT(onPhotosClicked()));
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    m_myId = QSettings().value("main/myId").toString();
    this->orientationChanged();
    bool whiteMode = QSettings().value("main/white-mode", false).toBool();
    if (whiteMode) {
        QPalette p(palette());
        p.setColor(QPalette::Background, QColor(220, 225, 235));
        setPalette(p);
    }
}

ProfileWindow::~ProfileWindow()
{
    delete ui;
}

void ProfileWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    ui->scrollAreaWidgetContents->setMaximumWidth(screenGeometry.width()-10);
}

void ProfileWindow::browseProfile(QString id)
{
    this->profileId = id;
    if (id == "me")
        ui->menuOptions->removeAction(ui->actionPoke);
    else
        setAttribute(Qt::WA_DeleteOnClose);
    QString url = QString("https://graph.facebook.com/%1/picture&access_token=%2&type=normal").arg(id, accessToken);
    this->avatarReply = nam->get(QNetworkRequest(url));
    connect(avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));

    this->infoReply = qfacebook->getObject(id);
    if (this->infoReply)
        connect(infoReply, SIGNAL(finished()), this, SLOT(onInfoReplyReceived()));

    this->reply = qfacebook->getConnections(this->profileId, "feed");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void ProfileWindow::onInfoReplyReceived()
{
    if (this->infoReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch profile info!";
        this->infoReply->deleteLater();
        this->infoReply = 0;

        return;
    }

    QVariant jsonData = this->infoReply->data();
    QString name = jsonData.toMap().value("name").toString();
    if (!name.isEmpty())
        this->setWindowTitle(name);
    QString birthday = jsonData.toMap().value("birthday").toString();
    QString fromLocation = jsonData.toMap().value("hometown").toMap().value("name").toString();
    QString currentLocation = jsonData.toMap().value("location").toMap().value("name").toString();
    QString relationshipStatus = jsonData.toMap().value("relationship_status").toString();

    if (relationshipStatus.isEmpty())
        ui->relationshipLabel->hide();
    else
        ui->relationshipLabel->setText(relationshipStatus);

    if (fromLocation.isEmpty())
        ui->fromLabel->hide();
    else
        ui->fromLabel->setText(tr("From %1").arg(fromLocation));

    if (currentLocation.isEmpty())
        ui->locationLabel->hide();
    else
        ui->locationLabel->setText(tr("Lives in %1").arg(currentLocation));

    if (birthday.isEmpty())
        ui->birthdateLabel->hide();
    else
        ui->birthdateLabel->setText(tr("Born on %1").arg(birthday));
}

void ProfileWindow::onAvatarClicked()
{
    PhotoWindow *photo = new PhotoWindow(this, accessToken);
    photo->showPhoto(profileId);
    photo->setWindowTitle(this->windowTitle() + " - " + tr("Profile picture"));
    photo->showMaximized();
}

void ProfileWindow::updateProfile()
{
    this->browseProfile(this->profileId);
}

void ProfileWindow::onPhotosClicked()
{
    AlbumsWindow *albums = new AlbumsWindow(this, accessToken);
    albums->setAttribute(Qt::WA_DeleteOnClose);
    albums->browseAlbums(profileId);
#ifdef Q_WS_S60
    albums->showMaximized();
#else
    albums->show();
#endif
}

void ProfileWindow::onAvatarReceived()
{
    QUrl redir = this->avatarReply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        this->avatarReply->deleteLater();
        this->avatarReply = nam->get(QNetworkRequest(redir));

        connect(this->avatarReply, SIGNAL(finished()), this, SLOT(onAvatarReceived()));
        return;
    }
    this->setAvatar(QPixmap::fromImage(QImage::fromData(this->avatarReply->readAll())));
    //this->avatarReply->deleteLater();
}

void ProfileWindow::setAvatar(QPixmap avatar)
{
    ui->userAvatar->setIcon(QIcon(avatar));
}

void ProfileWindow::onNewsFeedPostDestroyed(QObject *object)
{
    posts.removeOne((NewsFeedPost*)object);
}

void ProfileWindow::onReplyReceived()
{
    if (!posts.isEmpty()) {
        foreach (NewsFeedPost *post, posts) {
            ui->scrollLayout->removeWidget(post);
            delete post;
        }
        posts.clear();
    }

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch news feed!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }
    QString myId = QSettings().value("main/myId").toString();

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *post = new NewsFeedPost(ui->scrollArea, accessToken, qfacebook, nam);
        connect(post, SIGNAL(destroyed(QObject*)), this, SLOT(onNewsFeedPostDestroyed(QObject*)));
        connect(post, SIGNAL(nameClicked(QString,QString)), this, SLOT(onNameClicked(QString,QString)));
        connect(post, SIGNAL(commentButtonClicked(QString,QString,QString)),
                this, SLOT(onCommentButtonClicked(QString,QString,QString)));
        QString name = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        if (userId.contains(myId))
            post->setDeletable(true);
        if (this->profileId == "me")
            post->setDeletable(true);
        QString message = jsonData.toMap().value("message").toString();
        QString icon = jsonData.toMap().value("icon").toString();
        QString time = jsonData.toMap().value("created_time").toString();
        QString link = jsonData.toMap().value("link").toString();
        if (link.isEmpty())
            link = jsonData.toMap().value("source").toString();
        if (!link.isEmpty()) {
            post->addLink(link,
                          jsonData.toMap().value("name").toString(),
                          jsonData.toMap().value("description").toString(),
                          jsonData.toMap().value("picture").toString());
        }
        QVariantList toVariant = jsonData.toMap().value("to").toMap().value("data").toList();
        if (!toVariant.isEmpty()) {
            QVariant to = toVariant.first();
            if (message.contains(to.toMap().value("name").toString()) && toVariant.count() > 1)
                to = toVariant.at(1);

            QString toId = to.toMap().value("id").toString();
            QString toName = to.toMap().value("name").toString();

            QString thisId = profileId;
            if (thisId == "me")
                thisId = m_myId;

            if (toName != name && toId != thisId)
                post->setToName(toName, toId);
        }

        // Check if the currently logged in user likes the post
        QVariantList likes = jsonData.toMap().value("likes").toMap().value("data").toList();
        bool meLikesThis = false;
        QString myId = QSettings().value("main/myId").toString();
        foreach (QVariant likeId, likes) {
            QVariantMap map = likeId.value<QVariantMap>();
            QString likerId = map.value("id").toString();
            if (likerId.contains(myId))
                meLikesThis = true;
            else
                meLikesThis = false;
        }

        // Get like and comment count.
        QString likesCount = jsonData.toMap().value("likes").toMap().value("count").toString();
        if (likesCount.isEmpty())
            likesCount = "0";
        QString comments = jsonData.toMap().value("comments").toMap().value("count").toString();
        if (comments.isEmpty())
            comments = "0";

        // Set parsed data
        post->setName(name);
        post->setMessage(message);
        post->setId(jsonData.toMap().value("id").toString());
        post->setUserId(userId);
        post->getPixmapFromUrl(QString("http://graph.facebook.com/%1/picture").arg(userId));
        post->setLikedByMe(meLikesThis);
        post->setNumberOfLikesComments(likesCount, comments);
        post->setIconFromUrl(icon);
        post->setTime(time);
        posts.append(post);
        ui->scrollLayout->addWidget(post);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ProfileWindow::onTextBoxClicked()
{
    NewStatusUpdateDialog *dialog = new NewStatusUpdateDialog(this);
    connect(dialog, SIGNAL(postUpdate(QString,QString,QString)), this, SLOT(onPostToWall(QString,QString,QString)));
    dialog->setWindowTitle(tr("Post to wall"));
#ifdef Q_WS_S60
    dialog->showMaximized();
#else
    dialog->show();
#endif
}

void ProfileWindow::onPostToWall(QString text, QString link, QString video)
{
    dataToPost.clear();

    ui->writeOnWallEdit->setEnabled(false);

    if (!text.isEmpty()) {
        dataToPost.append("message=" + text.toUtf8());
        if (!link.isEmpty() || !video.isEmpty())
            dataToPost.append("&");
    }
    if (!link.isEmpty()) {
        dataToPost.append("link=" + link);
        if (!video.isEmpty())
            dataToPost.append("&");
    }
    if (!video.isEmpty())
        dataToPost.append("video=" + video);

    this->postReply = qfacebook->putObject(this->profileId, "feed", dataToPost);
    connect(postReply, SIGNAL(finished()), this, SLOT(onPosted()));
}

void ProfileWindow::onPosted()
{
    if (this->postReply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to post to wall!";
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Faled to post to wall"));
#else
        QMessageBox::information(this, tr("Error"), tr("Failed to post to wall"));
#endif
        this->postReply->deleteLater();
        this->postReply = 0;

        return;
    }

    ui->writeOnWallEdit->setEnabled(true);
    this->updateProfile();
}

void ProfileWindow::onNameClicked(QString id, QString name)
{
    if (id == QSettings().value("main/myId").toString() || id == "me" || id == this->profileId)
        return;

    ProfileWindow *profile = new ProfileWindow(this, accessToken);
    profile->browseProfile(id);
    profile->setWindowTitle(name);
#ifdef Q_WS_S60
    profile->showMaximized();
#else
    profile->show();
#endif
}

void ProfileWindow::onCommentButtonClicked(QString id, QString comments, QString likes)
{
    qDebug() << id;
    SinglePostWindow *window = new SinglePostWindow(this, accessToken);
    window->loadPost(id);
    window->setCountLabel(comments, likes);
#ifdef Q_WS_S60
    window->showMaximized();
#else
    window->show();
#endif
}
