#include "photowindow.h"
#include "ui_photowindow.h"
#include "newsfeedpost.h"

PhotoWindow::PhotoWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::PhotoWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->photoLabel, SIGNAL(clickedPos(QPoint)), this, SLOT(onClicked(QPoint)));
    connect(ui->actionDownload_photo, SIGNAL(triggered()), this, SLOT(downloadPhoto()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

PhotoWindow::~PhotoWindow()
{
    delete ui;
}

void PhotoWindow::showPhoto(QString photoId)
{
    this->photoId = photoId;
    QString urlString = QString("https://graph.facebook.com/%1/picture&type=large&access_token=%2").arg(photoId, accessToken);
    m_photoUrl = urlString;
    this->reply = nam->get(QNetworkRequest(urlString));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void PhotoWindow::showPhotoFromId(QString id)
{
    this->photoId = id;
    QString urlString = QString("https://graph.facebook.com/%1&type=large&access_token=%2").arg(photoId, accessToken);
    m_photoUrl = urlString;
    this->reply = nam->get(QNetworkRequest(urlString));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void PhotoWindow::setPixmap(QPixmap pixmap)
{
    ui->photoLabel->setPixmap(pixmap);
}

void PhotoWindow::setPixmapFromUrl(QString url)
{
    m_photoUrl = url;
    this->reply = nam->get(QNetworkRequest(url));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void PhotoWindow::setPhotoId(QString photoId)
{
    this->photoId = photoId;
}

void PhotoWindow::setUserId(QString userId)
{
    m_userId = userId;
}

void PhotoWindow::setPhoto(QString filename)
{
    ui->photoLabel->setPixmap(QPixmap(filename));
}

void PhotoWindow::onReplyReceived()
{
    ui->photoLabel->clear();

    if (reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch photo!";
        reply->deleteLater();
        reply = 0;

        return;
    }

    QUrl redir = reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toUrl();
    if (!redir.isEmpty()) {
        reply = qfacebook->get(redir);
        if (reply)
            connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
        return;
    }

    ui->photoLabel->setPixmap(QPixmap::fromImage(QImage::fromData(reply->readAll())));
}

void PhotoWindow::onClicked(QPoint point)
{
    double xOfPhoto = ui->photoLabel->x();
    double yOfPhoto = ui->photoLabel->y();
    double xOfClick = point.x();
    double yOfClick = point.y();

    qDebug() << "Percentage of x click: " << ((xOfClick - xOfPhoto) / ui->photoLabel->width()) * 100;
    qDebug() << "Percentage of y click: " << ((yOfClick - yOfPhoto) / ui->photoLabel->height()) * 100;
}

void PhotoWindow::setComments(QVariantList comments)
{
    m_comments = comments;
    foreach (QVariant comment, comments) {
        NewsFeedPost *item = new NewsFeedPost(this, accessToken, qfacebook, nam);
        item->setCommentMode(true);
        QString name = comment.toMap().value("from").toMap().value("name").toString();
        QString userId = comment.toMap().value("from").toMap().value("id").toString();
        item->setName(name);
        item->setUserId(userId);
        item->setMessage(comment.toMap().value("message").toString());
        item->setTime(comment.toMap().value("created_time").toString());
        item->getPixmapFromUserId(userId);
        commentsList.append(item);
        ui->commentsLayout->addWidget(item);
    }
}

void PhotoWindow::setTags(QVariantList tags)
{
    m_tags = tags;
}

void PhotoWindow::downloadPhoto()
{
    if (m_photoUrl.isEmpty()) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Unable to download: invalid URL"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Unable to download: invalid URL"));
#endif
        return;
    }

    m_downloadLocation = QFileDialog::getSaveFileName(this, tr("Save image as"),
                                                      QDir::homePath());
    if (m_downloadLocation.isEmpty()) {
        return;
    }

    setAttribute(Qt::WA_DeleteOnClose, false);

    m_downloadReply = nam->get(QNetworkRequest(m_photoUrl));
    connect(m_downloadReply, SIGNAL(finished()), this, SLOT(onDownloadFinished()));
}

void PhotoWindow::onDownloadFinished()
{
    QFile image(m_downloadLocation, this);
    if (image.open(QFile::WriteOnly)) {
        image.write(m_downloadReply->readAll());
        image.close();
    }

#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Download complete"));
#else
    QMessageBox::information(this, tr("Success"), tr("Photo downloaded"));
#endif
    setAttribute(Qt::WA_DeleteOnClose, true);
        if (!isVisible())
            this->deleteLater();
}
