#ifndef ALBUMWINDOW_H
#define ALBUMWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QDebug>
#include <QFileDialog>
#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif
#include <QMessageBox>
#include "widgets/photoitem.h"
#include "imageuploaddialog.h"
#include "qfacebook.h"

// Starts from 0, this means 4 columns
#define MAX_COLUMNS 3

namespace Ui {
    class AlbumWindow;
}

enum AlbumRoles {AlbumCount};

class AlbumWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit AlbumWindow(QWidget *parent = 0, QString token = "0");
    ~AlbumWindow();
    void browseAlbum(QString id, QString albumCount);

private:
    Ui::AlbumWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString accessToken;
    QString albumId;
    QNetworkAccessManager *nam;
    QString albumCount;
    QList<PhotoItem*> photos;
    QStringList sourceLinks;
    QDialog *progressDialog;
    int column;
    int row;
    int m_imagesCount;
    int m_finishedDownloads;
    QString m_downloadLocation;

private slots:
    void updateAlbum();
    void onReplyReceived();
    void uploadPhoto();
    void onPhotoItemClicked(PhotoItem*);
    void onDownloadFinished();
    void downloadAllPhotos();
};

#endif // ALBUMWINDOW_H
