#include "messageswindow.h"
#include "ui_messageswindow.h"

MessagesWindow::MessagesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::MessagesWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    connect(ui->messagesList, SIGNAL(itemActivated(QListWidgetItem*)), this, SLOT(onItemActivated(QListWidgetItem*)));
    connect(ui->newMessageButton, SIGNAL(clicked()), this, SLOT(onNewMessageButtonClicked()));
    this->updateMessages();
}

MessagesWindow::~MessagesWindow()
{
    delete ui;
}

void MessagesWindow::updateMessages()
{
    this->reply = qfacebook->getConnections("me", "inbox");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void MessagesWindow::onReplyReceived()
{
    ui->messagesList->clear();

    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch messages!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        QListWidgetItem *item = new QListWidgetItem();
        QString text;
        QString from = jsonData.toMap().value("from").toMap().value("name").toString();
        text.append(from + "\n\n");
        QString message = jsonData.toMap().value("message").toString();
        if (message.size() > 100) {
            message.truncate(100);
            message.append("...");
        }
        text.append(message);
        item->setText(text);
        item->setData(Qt::UserRole, jsonData.toMap().value("id").toString());
        ui->messagesList->addItem(item);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void MessagesWindow::onItemActivated(QListWidgetItem *item)
{
    MessageView *message = new MessageView(this, this->accessToken);
    message->parseMessageById(item->data(Qt::UserRole).toString());
    message->show();
}

void MessagesWindow::onNewMessageButtonClicked()
{
    ComposeMessage *messageComposer = new ComposeMessage(this, this->accessToken);
    messageComposer->show();
}
