#include "loginwindow.h"
#include "ui_loginwindow.h"

LoginWindow::LoginWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::LoginWindow)
{
    ui->setupUi(this);
    QString url = QString(authUrl).arg(perms);
    ui->webView->setUrl(QUrl(url));
    connect(ui->webView, SIGNAL(urlChanged(QUrl)), this, SLOT(onUrlChanged(QUrl)));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onInitalLoadFinished(bool)));
    setAttribute(Qt::WA_DeleteOnClose);
    disableCloseButton = false;
    isLoggingIn = false;
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    QWebViewSelectionSuppressor *suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
#endif
}

LoginWindow::~LoginWindow()
{
    delete ui;
}

void LoginWindow::onInitalLoadFinished(bool)
{
    disconnect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(onInitalLoadFinished(bool)));
    connect(ui->webView, SIGNAL(loadStarted()), this, SLOT(onLoadStarted()));
}

void LoginWindow::onLoadStarted()
{
    isLoggingIn = true;
}

void LoginWindow::onUrlChanged(QUrl url)
{
    if (url.toString().contains("https://www.facebook.com/connect/login_success.html#access_token=")) {
        QString urlString = url.toString();
        QString accessToken = urlString.remove("https://www.facebook.com/connect/login_success.html#access_token=").remove("&expires_in*");
        int position = accessToken.indexOf('&');
        accessToken = accessToken.remove(position, accessToken.length()-position);
        emit loggedIn(accessToken);
        this->onLoggedIn();
    }
}

void LoginWindow::onLoggedIn()
{
    disableCloseButton = false;
    this->close();
}

void LoginWindow::closeEvent(QCloseEvent *e)
{
    if (disableCloseButton)
        e->ignore();

    if (!isLoggingIn)
        qApp->closeAllWindows();
}
