#ifndef ALBUMWINDOW_H
#define ALBUMWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QDebug>
#include <QListWidgetItem>
#include "imageuploaddialog.h"
#include "qfacebook.h"

namespace Ui {
    class AlbumWindow;
}

enum AlbumRoles {AlbumCount};

class AlbumWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit AlbumWindow(QWidget *parent = 0, QString token = "0");
    ~AlbumWindow();
    void browseAlbum(QString id, QString albumCount);

private:
    Ui::AlbumWindow *ui;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QString accessToken;
    QString albumId;
    QNetworkAccessManager *nam;
    QString albumCount;

private slots:
    void updateAlbum();
    void onReplyReceived();
    void onImageProcessed(QString id, QPixmap pixmap);
    void uploadPhoto();
};

class Image : public QObject
{
    Q_OBJECT

public:
    explicit Image(QWidget *parent = 0, QListWidgetItem *item = 0);
    ~Image();

signals:
    void imageProcessed(QString id, QPixmap image);

private:
    QString id;
    QListWidgetItem *item;

private slots:
    void imageReceived();
};

#endif // ALBUMWINDOW_H
