#ifndef PLACEITEM_H
#define PLACEITEM_H

#include <QWidget>
#include <QNetworkAccessManager>
#include <QMouseEvent>
#include <QPainter>
#include <QDebug>
#include <qfacebook.h>

namespace Ui {
    class PlaceItem;
}

class PlaceItem : public QWidget
{
    Q_OBJECT

public:
    explicit PlaceItem(QWidget *parent = 0, QString token = "0", QNetworkAccessManager *nam = 0);
    ~PlaceItem();
    void setName(QString name);
    void setLocation(QString location);
    void setUserId(QString id);
    void setAvatarUrl(QString url);
    void setTime(QString time);
    void setCheckinId(QString id);
    void setCoordinates(double longitude, double latitude);
    void setPlaceId(QString id);
    bool isPressed();

protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void paintEvent(QPaintEvent *);

signals:
    void pressed();
    void released();
    void clicked(QString id);

private:
    Ui::PlaceItem *ui;
    QString accessToken;
    QNetworkAccessManager *nam;
    QNetworkReply *avatarReply;
    QString m_userId;
    QString m_checkinId;
    QString m_placeId;
    double m_longitude;
    double m_latitude;
    bool m_pressed;

private slots:
    void onAvatarReceived();
};

#endif // PLACEITEM_H
