#include "newalbumdialog.h"
#include "ui_newalbumdialog.h"

NewAlbumDialog::NewAlbumDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NewAlbumDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setMinimumHeight(250);
#endif
}

NewAlbumDialog::~NewAlbumDialog()
{
    delete ui;
}

void NewAlbumDialog::accept()
{
    if (ui->albumNameEdit->text().isEmpty()) {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Name field cannot be empty!"));
#else
        QMessageBox::warning(this, tr("Error"), tr("Name field cannot be empty!"));
#endif
        return;
    }

    emit createAlbum(ui->albumNameEdit->text(), ui->albumDescriptionEdit->text(), ui->locationEdit->text());
    this->close();
}
