#include "messageswindow.h"
#include "ui_messageswindow.h"

MessagesWindow::MessagesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::MessagesWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    this->updateMessages();
}

MessagesWindow::~MessagesWindow()
{
    delete ui;
}

void MessagesWindow::updateMessages()
{
    this->reply = qfacebook->getConnections("me", "inbox");
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void MessagesWindow::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch messages!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    foreach (NewsFeedPost *message, messages) {
        ui->scrollLayout->removeWidget(message);
        messages.removeOne(message);
        delete message;
    }

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        NewsFeedPost *item = new NewsFeedPost(this, accessToken, qfacebook, nam);
        item->setMessageMode(true);
        item->setDeletable(true);
        connect(item, SIGNAL(clicked(QString)), this, SLOT(onMessageClicked(QString)));
        QString from = jsonData.toMap().value("from").toMap().value("name").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        QString id = jsonData.toMap().value("id").toString();
        QString message = jsonData.toMap().value("message").toString();
        if (message.size() > 100) {
            message.truncate(100);
            message.append("...");
        }
        item->setUserId(userId);
        item->setName(from);
        item->setMessage(message);
        item->getPixmapFromUrl(QString("https://graph.facebook.com/%1/picture&access_token=%2").arg(userId, accessToken));
        item->setId(id);
        ui->scrollLayout->addWidget(item);
        messages.append(item);
    }
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void MessagesWindow::onMessageClicked(QString id)
{
    MessageView *message = new MessageView(this, this->accessToken);
    message->parseMessageById(id);
    message->show();
}

void MessagesWindow::onNewMessageButtonClicked()
{
    ComposeMessage *messageComposer = new ComposeMessage(this, this->accessToken);
    messageComposer->show();
}
