#include "albumwindow.h"
#include "ui_albumwindow.h"

AlbumWindow::AlbumWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::AlbumWindow),
    qfacebook(new QFacebook(token, this)),
    accessToken(token),
    nam(new QNetworkAccessManager(this))
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    connect(ui->actionUpload_photo, SIGNAL(triggered()), this, SLOT(uploadPhoto()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
}

AlbumWindow::~AlbumWindow()
{
    delete ui;
}

void AlbumWindow::browseAlbum(QString id, QString albumCount)
{
    this->albumId = id;
    this->albumCount = albumCount;
    this->updateAlbum();
}

void AlbumWindow::uploadPhoto()
{
    ImageUploadDialog *dialog = new ImageUploadDialog(this);
    dialog->show();
}

void AlbumWindow::updateAlbum()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    this->reply = qfacebook->getObject(this->albumId + QString("/photos&limit=0"));
    if (this->reply)
        connect(reply, SIGNAL(finished()), this, SLOT(onReplyReceived()));
}

void AlbumWindow::onReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch album!";
        this->reply->deleteLater();
        this->reply = 0;
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
        return;
    }

    foreach (PhotoItem *item, photos) {
        ui->gridLayout->removeWidget(item);
        delete item;
    }

    column = 0;
    row = 0;

    QVariant jsonData = this->reply->data();
    QVariantList listData;
    listData = jsonData.toMap().value("data").toList();
    foreach(jsonData, listData) {
        // One image at a time...
        QVariantList imagesList = jsonData.toMap().value("images").toList();
        QString id = jsonData.toMap().value("id").toString();
        QString userId = jsonData.toMap().value("from").toMap().value("id").toString();
        //QString userName = jsonData.toMap().value("from").toMap().value("name").toString();
        QString normalUrl;
        QString smallUrl;
        QString thumbUrl;
        QString mediumUrl;
        QString sourceUrl = jsonData.toMap().value("source").toString();
        foreach (QVariant imageVariant, imagesList) {
            QString imageUrl = imageVariant.toMap().value("source").toString();
            if (imageUrl.endsWith("n.jpg"))
                normalUrl = imageUrl;
            else if (imageUrl.endsWith("s.jpg"))
                smallUrl = imageUrl;
            else if (imageUrl.endsWith("t.jpg"))
                thumbUrl = imageUrl;
            else if (imageUrl.endsWith("a.jpg"))
                mediumUrl = imageUrl;
        }
        PhotoItem *item = new PhotoItem(this, accessToken, nam);
        item->setComments(jsonData.toMap().value("comments").toMap().value("data").toList());
        item->setTags(jsonData.toMap().value("tags").toMap().value("data").toList());
        connect(item, SIGNAL(clicked(PhotoItem*)), this, SLOT(onPhotoItemClicked(PhotoItem*)));
        item->setPixmapFromUrl(mediumUrl);
        item->setLargePhotoLink(normalUrl);
        item->setSmallPhotoLink(smallUrl);
        item->setPhotoId(id);
        item->setUserId(userId);
        item->setSourcePhotoLink(sourceUrl);
        if (column > MAX_COLUMNS) {
            column = 0;
            row++;
        }
        ui->gridLayout->addWidget(item, row, column);
        photos.append(item);
        column++;
    }

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

    reply->deleteLater();
}

void AlbumWindow::onPhotoItemClicked(PhotoItem *item)
{
    PhotoWindow *photo = new PhotoWindow(this, accessToken);
    photo->setPixmapFromUrl(item->largeUrl()            );
    photo->setWindowTitle(tr("Photo"));
    photo->setComments(item->comments());
    photo->setTags(item->tags());
#ifdef Q_WS_S60
    photo->showMaximized();
#else
    photo->show();
#endif
}
