#ifndef SINGLEPOSTWINDOW_H
#define SINGLEPOSTWINDOW_H

#include <QMainWindow>
#include <QDebug>
#include <QSettings>
#include <qfacebook.h>
#include "newsfeedpost.h"
#ifndef Q_WS_MAEMO_5
    #include <QMessageBox>
#endif

namespace Ui {
    class SinglePostWindow;
}

class SinglePostWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit SinglePostWindow(QWidget *parent = 0, QString token = "0");
    ~SinglePostWindow();
    void loadPost(QString id);
    void setCountLabel(QString comments, QString likes);

private:
    Ui::SinglePostWindow *ui;
    QString accessToken;
    QFacebook *qfacebook;
    QFacebookReply *reply;
    QFacebookReply *commentReply;
    QString postId;
    QList<NewsFeedPost*> posts;
    QNetworkAccessManager *nam;
    bool gotMainPost;
    QString myId;

private slots:
    void onReplyReceived();
    void onCommentReplyReceived();
    void onPostButtonClicked();
    void orientationChanged();
};

#endif // SINGLEPOSTWINDOW_H
