#ifndef PLACESWINDOW_H
#define PLACESWINDOW_H

#include <QMainWindow>
#ifdef MOBILITY
    #include <QGeoPositionInfo>
    #include <QGeoPositionInfoSource>
#endif
#include <QDebug>
#include <qfacebook.h>

#include "widgets/placeitem.h"

#ifdef MOBILITY
    QTM_USE_NAMESPACE
#endif
namespace Ui {
    class PlacesWindow;
}

class PlacesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PlacesWindow(QWidget *parent = 0, QString token = "0");
    ~PlacesWindow();

protected:
    void closeEvent(QCloseEvent *);

private:
    Ui::PlacesWindow *ui;
    QString accessToken;
#ifdef MOBILITY
    QGeoPositionInfoSource *source;
#endif
    QFacebook *qfacebook;
    QFacebookReply *reply;
    double longitude;
    double latitude;

private slots:
#ifdef MOBILITY
    void onPositionUpdated(QGeoPositionInfo info);
#endif
    void onSearchReplyReceived();
};

#endif // PLACESWINDOW_H
