#include "placeswindow.h"
#include "ui_placeswindow.h"

PlacesWindow::PlacesWindow(QWidget *parent, QString token) :
    QMainWindow(parent),
    ui(new Ui::PlacesWindow),
    accessToken(token),
#ifdef MOBILITY
    source(QGeoPositionInfoSource::createDefaultSource(this)),
#endif
    qfacebook(new QFacebook(token, this))
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef MOBILITY
    if (source) {
        source->setPreferredPositioningMethods(QGeoPositionInfoSource::SatellitePositioningMethods);
        source->setUpdateInterval(10000);
        connect(source, SIGNAL(positionUpdated(QGeoPositionInfo)), this, SLOT(onPositionUpdated(QGeoPositionInfo)));
        source->startUpdates();
    }
#endif
}

PlacesWindow::~PlacesWindow()
{
    delete ui;
}

#ifdef MOBILITY
void PlacesWindow::onPositionUpdated(QGeoPositionInfo info)
{
    QGeoCoordinate coordinates = info.coordinate();
    longitude = coordinates.longitude();
    latitude = coordinates.latitude();
    QString locationString = QString::number(longitude) + "," + QString::number(latitude);

}
#endif

void PlacesWindow::onSearchReplyReceived()
{
    if (this->reply->error() != QNetworkReply::NoError) {
        qDebug() << "Failed to fetch news feed!";
        this->reply->deleteLater();
        this->reply = 0;

        return;
    }

    QVariant jsonData = this->reply->data();
    qDebug() << jsonData;
}

void PlacesWindow::closeEvent(QCloseEvent *)
{
#ifdef MOBILITY
    if (source)
        source->stopUpdates();
#endif
}
